--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDeviceAction = {}

---@class GeneralHardwareIpmiCmds.SetDeviceActionReq
---@field ManufactureId integer
---@field Slot integer
local TSetDeviceActionReq = {}
TSetDeviceActionReq.__index = TSetDeviceActionReq
TSetDeviceActionReq.group = {}

local function TSetDeviceActionReq_from_obj(obj)
    return setmetatable(obj, TSetDeviceActionReq)
end

function TSetDeviceActionReq.new(ManufactureId, Slot)
    return TSetDeviceActionReq_from_obj({ManufactureId = ManufactureId, Slot = Slot})
end
---@param obj GeneralHardwareIpmiCmds.SetDeviceActionReq
function TSetDeviceActionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Slot = obj.Slot
end

function TSetDeviceActionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceActionReq.group)
end

TSetDeviceActionReq.from_obj = TSetDeviceActionReq_from_obj

TSetDeviceActionReq.proto_property = {'ManufactureId', 'Slot'}

TSetDeviceActionReq.default = {0, 0}

TSetDeviceActionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Slot', is_array = false, struct = nil}
}

function TSetDeviceActionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSetDeviceActionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceActionReq.proto_property, errs, need_convert)
    return self
end

function TSetDeviceActionReq:unpack(_)
    return self.ManufactureId, self.Slot
end

SetDeviceAction.SetDeviceActionReq = TSetDeviceActionReq

---@class GeneralHardwareIpmiCmds.SetDeviceActionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDeviceActionRsp = {}
TSetDeviceActionRsp.__index = TSetDeviceActionRsp
TSetDeviceActionRsp.group = {}

local function TSetDeviceActionRsp_from_obj(obj)
    return setmetatable(obj, TSetDeviceActionRsp)
end

function TSetDeviceActionRsp.new(CompletionCode, ManufactureId)
    return TSetDeviceActionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDeviceActionRsp
function TSetDeviceActionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDeviceActionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceActionRsp.group)
end

TSetDeviceActionRsp.from_obj = TSetDeviceActionRsp_from_obj

TSetDeviceActionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDeviceActionRsp.default = {0, 0}

TSetDeviceActionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDeviceActionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDeviceActionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceActionRsp.proto_property, errs, need_convert)
    return self
end

function TSetDeviceActionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDeviceAction.SetDeviceActionRsp = TSetDeviceActionRsp

return SetDeviceAction
