--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local RestSDI = {}

---@class GeneralHardwareIpmiCmds.RestSDIReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
local TRestSDIReq = {}
TRestSDIReq.__index = TRestSDIReq
TRestSDIReq.group = {}

local function TRestSDIReq_from_obj(obj)
    return setmetatable(obj, TRestSDIReq)
end

function TRestSDIReq.new(ManufactureId, Reserved, DeviceNo, Offset)
    return TRestSDIReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset
    })
end
---@param obj GeneralHardwareIpmiCmds.RestSDIReq
function TRestSDIReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
end

function TRestSDIReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestSDIReq.group)
end

TRestSDIReq.from_obj = TRestSDIReq_from_obj

TRestSDIReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset'}

TRestSDIReq.default = {0, 0, 0, 0}

TRestSDIReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil}
}

function TRestSDIReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)

    TRestSDIReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestSDIReq.proto_property, errs, need_convert)
    return self
end

function TRestSDIReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset
end

RestSDI.RestSDIReq = TRestSDIReq

---@class GeneralHardwareIpmiCmds.RestSDIRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TRestSDIRsp = {}
TRestSDIRsp.__index = TRestSDIRsp
TRestSDIRsp.group = {}

local function TRestSDIRsp_from_obj(obj)
    return setmetatable(obj, TRestSDIRsp)
end

function TRestSDIRsp.new(CompletionCode, ManufactureId)
    return TRestSDIRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.RestSDIRsp
function TRestSDIRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TRestSDIRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestSDIRsp.group)
end

TRestSDIRsp.from_obj = TRestSDIRsp_from_obj

TRestSDIRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TRestSDIRsp.default = {0, 0}

TRestSDIRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TRestSDIRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TRestSDIRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestSDIRsp.proto_property, errs, need_convert)
    return self
end

function TRestSDIRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

RestSDI.RestSDIRsp = TRestSDIRsp

return RestSDI
