--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSystemInfoParameters = {}

---@class GeneralHardwareIpmiCmds.GetSystemInfoParametersReq
---@field Rsvd integer
---@field SetSelector integer
---@field BlocktSelector integer
local TGetSystemInfoParametersReq = {}
TGetSystemInfoParametersReq.__index = TGetSystemInfoParametersReq
TGetSystemInfoParametersReq.group = {}

local function TGetSystemInfoParametersReq_from_obj(obj)
    return setmetatable(obj, TGetSystemInfoParametersReq)
end

function TGetSystemInfoParametersReq.new(Rsvd, SetSelector, BlocktSelector)
    return TGetSystemInfoParametersReq_from_obj({
        Rsvd = Rsvd,
        SetSelector = SetSelector,
        BlocktSelector = BlocktSelector
    })
end
---@param obj GeneralHardwareIpmiCmds.GetSystemInfoParametersReq
function TGetSystemInfoParametersReq:init_from_obj(obj)
    self.Rsvd = obj.Rsvd
    self.SetSelector = obj.SetSelector
    self.BlocktSelector = obj.BlocktSelector
end

function TGetSystemInfoParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSystemInfoParametersReq.group)
end

TGetSystemInfoParametersReq.from_obj = TGetSystemInfoParametersReq_from_obj

TGetSystemInfoParametersReq.proto_property = {'Rsvd', 'SetSelector', 'BlocktSelector'}

TGetSystemInfoParametersReq.default = {0, 0, 0}

TGetSystemInfoParametersReq.struct = {
    {name = 'Rsvd', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlocktSelector', is_array = false, struct = nil}
}

function TGetSystemInfoParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Rsvd', self.Rsvd, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlocktSelector', self.BlocktSelector, 'uint8', false, errs, need_convert)

    TGetSystemInfoParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSystemInfoParametersReq.proto_property, errs, need_convert)
    return self
end

function TGetSystemInfoParametersReq:unpack(_)
    return self.Rsvd, self.SetSelector, self.BlocktSelector
end

GetSystemInfoParameters.GetSystemInfoParametersReq = TGetSystemInfoParametersReq

---@class GeneralHardwareIpmiCmds.GetSystemInfoParametersRsp
---@field CompletionCode integer
---@field SetSelector integer
---@field Data string
local TGetSystemInfoParametersRsp = {}
TGetSystemInfoParametersRsp.__index = TGetSystemInfoParametersRsp
TGetSystemInfoParametersRsp.group = {}

local function TGetSystemInfoParametersRsp_from_obj(obj)
    return setmetatable(obj, TGetSystemInfoParametersRsp)
end

function TGetSystemInfoParametersRsp.new(CompletionCode, SetSelector, Data)
    return TGetSystemInfoParametersRsp_from_obj({
        CompletionCode = CompletionCode,
        SetSelector = SetSelector,
        Data = Data
    })
end
---@param obj GeneralHardwareIpmiCmds.GetSystemInfoParametersRsp
function TGetSystemInfoParametersRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.SetSelector = obj.SetSelector
    self.Data = obj.Data
end

function TGetSystemInfoParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSystemInfoParametersRsp.group)
end

TGetSystemInfoParametersRsp.from_obj = TGetSystemInfoParametersRsp_from_obj

TGetSystemInfoParametersRsp.proto_property = {'CompletionCode', 'SetSelector', 'Data'}

TGetSystemInfoParametersRsp.default = {0, 0, ''}

TGetSystemInfoParametersRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetSystemInfoParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetSystemInfoParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSystemInfoParametersRsp.proto_property, errs, need_convert)
    return self
end

function TGetSystemInfoParametersRsp:unpack(_)
    return self.CompletionCode, self.SetSelector, self.Data
end

GetSystemInfoParameters.GetSystemInfoParametersRsp = TGetSystemInfoParametersRsp

return GetSystemInfoParameters
