--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSecurityModuleInfo = {}

---@class GeneralHardwareIpmiCmds.GetSecurityModuleInfoReq
---@field ManufactureId integer
local TGetSecurityModuleInfoReq = {}
TGetSecurityModuleInfoReq.__index = TGetSecurityModuleInfoReq
TGetSecurityModuleInfoReq.group = {}

local function TGetSecurityModuleInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSecurityModuleInfoReq)
end

function TGetSecurityModuleInfoReq.new(ManufactureId)
    return TGetSecurityModuleInfoReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.GetSecurityModuleInfoReq
function TGetSecurityModuleInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetSecurityModuleInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSecurityModuleInfoReq.group)
end

TGetSecurityModuleInfoReq.from_obj = TGetSecurityModuleInfoReq_from_obj

TGetSecurityModuleInfoReq.proto_property = {'ManufactureId'}

TGetSecurityModuleInfoReq.default = {0}

TGetSecurityModuleInfoReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetSecurityModuleInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetSecurityModuleInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSecurityModuleInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSecurityModuleInfoReq:unpack(_)
    return self.ManufactureId
end

GetSecurityModuleInfo.GetSecurityModuleInfoReq = TGetSecurityModuleInfoReq

---@class GeneralHardwareIpmiCmds.GetSecurityModuleInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Presence integer
---@field SecurityModuleInfo string
local TGetSecurityModuleInfoRsp = {}
TGetSecurityModuleInfoRsp.__index = TGetSecurityModuleInfoRsp
TGetSecurityModuleInfoRsp.group = {}

local function TGetSecurityModuleInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSecurityModuleInfoRsp)
end

function TGetSecurityModuleInfoRsp.new(CompletionCode, ManufactureId, Presence, SecurityModuleInfo)
    return TGetSecurityModuleInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Presence = Presence,
        SecurityModuleInfo = SecurityModuleInfo
    })
end
---@param obj GeneralHardwareIpmiCmds.GetSecurityModuleInfoRsp
function TGetSecurityModuleInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Presence = obj.Presence
    self.SecurityModuleInfo = obj.SecurityModuleInfo
end

function TGetSecurityModuleInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSecurityModuleInfoRsp.group)
end

TGetSecurityModuleInfoRsp.from_obj = TGetSecurityModuleInfoRsp_from_obj

TGetSecurityModuleInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Presence', 'SecurityModuleInfo'}

TGetSecurityModuleInfoRsp.default = {0, 0, 0, ''}

TGetSecurityModuleInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Presence', is_array = false, struct = nil}, {name = 'SecurityModuleInfo', is_array = false, struct = nil}
}

function TGetSecurityModuleInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SecurityModuleInfo', self.SecurityModuleInfo, 'string', false, errs, need_convert)

    TGetSecurityModuleInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSecurityModuleInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSecurityModuleInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Presence, self.SecurityModuleInfo
end

GetSecurityModuleInfo.GetSecurityModuleInfoRsp = TGetSecurityModuleInfoRsp

return GetSecurityModuleInfo
