--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetHttpsEnable = {}

---@class GeneralHardwareIpmiCmds.GetHttpsEnableReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetHttpsEnableReq = {}
TGetHttpsEnableReq.__index = TGetHttpsEnableReq
TGetHttpsEnableReq.group = {}

local function TGetHttpsEnableReq_from_obj(obj)
    return setmetatable(obj, TGetHttpsEnableReq)
end

function TGetHttpsEnableReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetHttpsEnableReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetHttpsEnableReq
function TGetHttpsEnableReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetHttpsEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHttpsEnableReq.group)
end

TGetHttpsEnableReq.from_obj = TGetHttpsEnableReq_from_obj

TGetHttpsEnableReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetHttpsEnableReq.default = {0, 0, 0, 0}

TGetHttpsEnableReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetHttpsEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetHttpsEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHttpsEnableReq.proto_property, errs, need_convert)
    return self
end

function TGetHttpsEnableReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetHttpsEnable.GetHttpsEnableReq = TGetHttpsEnableReq

---@class GeneralHardwareIpmiCmds.GetHttpsEnableRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field PxeOption integer
local TGetHttpsEnableRsp = {}
TGetHttpsEnableRsp.__index = TGetHttpsEnableRsp
TGetHttpsEnableRsp.group = {}

local function TGetHttpsEnableRsp_from_obj(obj)
    return setmetatable(obj, TGetHttpsEnableRsp)
end

function TGetHttpsEnableRsp.new(CompletionCode, ManufactureId, EndOfList, PxeOption)
    return TGetHttpsEnableRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        PxeOption = PxeOption
    })
end
---@param obj GeneralHardwareIpmiCmds.GetHttpsEnableRsp
function TGetHttpsEnableRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.PxeOption = obj.PxeOption
end

function TGetHttpsEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHttpsEnableRsp.group)
end

TGetHttpsEnableRsp.from_obj = TGetHttpsEnableRsp_from_obj

TGetHttpsEnableRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'PxeOption'}

TGetHttpsEnableRsp.default = {0, 0, 0, 0}

TGetHttpsEnableRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'PxeOption', is_array = false, struct = nil}
}

function TGetHttpsEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PxeOption', self.PxeOption, 'uint8', false, errs, need_convert)

    TGetHttpsEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHttpsEnableRsp.proto_property, errs, need_convert)
    return self
end

function TGetHttpsEnableRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.PxeOption
end

GetHttpsEnable.GetHttpsEnableRsp = TGetHttpsEnableRsp

return GetHttpsEnable
