--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetGpuChipInfo = {}

---@class GeneralHardwareIpmiCmds.GetGpuChipInfoReq
---@field ManufactureId integer
---@field Length integer
---@field Data string
local TGetGpuChipInfoReq = {}
TGetGpuChipInfoReq.__index = TGetGpuChipInfoReq
TGetGpuChipInfoReq.group = {}

local function TGetGpuChipInfoReq_from_obj(obj)
    return setmetatable(obj, TGetGpuChipInfoReq)
end

function TGetGpuChipInfoReq.new(ManufactureId, Length, Data)
    return TGetGpuChipInfoReq_from_obj({ManufactureId = ManufactureId, Length = Length, Data = Data})
end
---@param obj GeneralHardwareIpmiCmds.GetGpuChipInfoReq
function TGetGpuChipInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetGpuChipInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetGpuChipInfoReq.group)
end

TGetGpuChipInfoReq.from_obj = TGetGpuChipInfoReq_from_obj

TGetGpuChipInfoReq.proto_property = {'ManufactureId', 'Length', 'Data'}

TGetGpuChipInfoReq.default = {0, 0, ''}

TGetGpuChipInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetGpuChipInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetGpuChipInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetGpuChipInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetGpuChipInfoReq:unpack(_)
    return self.ManufactureId, self.Length, self.Data
end

GetGpuChipInfo.GetGpuChipInfoReq = TGetGpuChipInfoReq

---@class GeneralHardwareIpmiCmds.GetGpuChipInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetGpuChipInfoRsp = {}
TGetGpuChipInfoRsp.__index = TGetGpuChipInfoRsp
TGetGpuChipInfoRsp.group = {}

local function TGetGpuChipInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetGpuChipInfoRsp)
end

function TGetGpuChipInfoRsp.new(CompletionCode, ManufactureId, Data)
    return TGetGpuChipInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj GeneralHardwareIpmiCmds.GetGpuChipInfoRsp
function TGetGpuChipInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetGpuChipInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetGpuChipInfoRsp.group)
end

TGetGpuChipInfoRsp.from_obj = TGetGpuChipInfoRsp_from_obj

TGetGpuChipInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetGpuChipInfoRsp.default = {0, 0, ''}

TGetGpuChipInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetGpuChipInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetGpuChipInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetGpuChipInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetGpuChipInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetGpuChipInfo.GetGpuChipInfoRsp = TGetGpuChipInfoRsp

return GetGpuChipInfo
