--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuSystemStatus = {}

---@class GeneralHardwareIpmiCmds.GetDpuSystemStatusReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuSystemStatusReq = {}
TGetDpuSystemStatusReq.__index = TGetDpuSystemStatusReq
TGetDpuSystemStatusReq.group = {}

local function TGetDpuSystemStatusReq_from_obj(obj)
    return setmetatable(obj, TGetDpuSystemStatusReq)
end

function TGetDpuSystemStatusReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuSystemStatusReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSystemStatusReq
function TGetDpuSystemStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuSystemStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSystemStatusReq.group)
end

TGetDpuSystemStatusReq.from_obj = TGetDpuSystemStatusReq_from_obj

TGetDpuSystemStatusReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuSystemStatusReq.default = {0, 0, 0, 0}

TGetDpuSystemStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuSystemStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuSystemStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSystemStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuSystemStatusReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuSystemStatus.GetDpuSystemStatusReq = TGetDpuSystemStatusReq

---@class GeneralHardwareIpmiCmds.GetDpuSystemStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field SystemStatus integer
local TGetDpuSystemStatusRsp = {}
TGetDpuSystemStatusRsp.__index = TGetDpuSystemStatusRsp
TGetDpuSystemStatusRsp.group = {}

local function TGetDpuSystemStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuSystemStatusRsp)
end

function TGetDpuSystemStatusRsp.new(CompletionCode, ManufactureId, EndOfList, SystemStatus)
    return TGetDpuSystemStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        SystemStatus = SystemStatus
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSystemStatusRsp
function TGetDpuSystemStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.SystemStatus = obj.SystemStatus
end

function TGetDpuSystemStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSystemStatusRsp.group)
end

TGetDpuSystemStatusRsp.from_obj = TGetDpuSystemStatusRsp_from_obj

TGetDpuSystemStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'SystemStatus'}

TGetDpuSystemStatusRsp.default = {0, 0, 0, 0}

TGetDpuSystemStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'SystemStatus', is_array = false, struct = nil}
}

function TGetDpuSystemStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemStatus', self.SystemStatus, 'uint8', false, errs, need_convert)

    TGetDpuSystemStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSystemStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuSystemStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.SystemStatus
end

GetDpuSystemStatus.GetDpuSystemStatusRsp = TGetDpuSystemStatusRsp

return GetDpuSystemStatus
