--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuSolSwitch = {}

---@class GeneralHardwareIpmiCmds.GetDpuSolSwitchReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetDpuSolSwitchReq = {}
TGetDpuSolSwitchReq.__index = TGetDpuSolSwitchReq
TGetDpuSolSwitchReq.group = {}

local function TGetDpuSolSwitchReq_from_obj(obj)
    return setmetatable(obj, TGetDpuSolSwitchReq)
end

function TGetDpuSolSwitchReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetDpuSolSwitchReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSolSwitchReq
function TGetDpuSolSwitchReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuSolSwitchReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSolSwitchReq.group)
end

TGetDpuSolSwitchReq.from_obj = TGetDpuSolSwitchReq_from_obj

TGetDpuSolSwitchReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetDpuSolSwitchReq.default = {0, 0, 0, 0}

TGetDpuSolSwitchReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuSolSwitchReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuSolSwitchReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSolSwitchReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuSolSwitchReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetDpuSolSwitch.GetDpuSolSwitchReq = TGetDpuSolSwitchReq

---@class GeneralHardwareIpmiCmds.GetDpuSolSwitchRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Uart integer
local TGetDpuSolSwitchRsp = {}
TGetDpuSolSwitchRsp.__index = TGetDpuSolSwitchRsp
TGetDpuSolSwitchRsp.group = {}

local function TGetDpuSolSwitchRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuSolSwitchRsp)
end

function TGetDpuSolSwitchRsp.new(CompletionCode, ManufactureId, EndOfList, Uart)
    return TGetDpuSolSwitchRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Uart = Uart
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSolSwitchRsp
function TGetDpuSolSwitchRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Uart = obj.Uart
end

function TGetDpuSolSwitchRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSolSwitchRsp.group)
end

TGetDpuSolSwitchRsp.from_obj = TGetDpuSolSwitchRsp_from_obj

TGetDpuSolSwitchRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Uart'}

TGetDpuSolSwitchRsp.default = {0, 0, 0, 0}

TGetDpuSolSwitchRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Uart', is_array = false, struct = nil}
}

function TGetDpuSolSwitchRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Uart', self.Uart, 'uint8', false, errs, need_convert)

    TGetDpuSolSwitchRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSolSwitchRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuSolSwitchRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Uart
end

GetDpuSolSwitch.GetDpuSolSwitchRsp = TGetDpuSolSwitchRsp

return GetDpuSolSwitch
