--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuSecureBoot = {}

---@class GeneralHardwareIpmiCmds.GetDpuSecureBootReq
---@field ManufactureId integer
---@field DeviceNo integer
local TGetDpuSecureBootReq = {}
TGetDpuSecureBootReq.__index = TGetDpuSecureBootReq
TGetDpuSecureBootReq.group = {}

local function TGetDpuSecureBootReq_from_obj(obj)
    return setmetatable(obj, TGetDpuSecureBootReq)
end

function TGetDpuSecureBootReq.new(ManufactureId, DeviceNo)
    return TGetDpuSecureBootReq_from_obj({ManufactureId = ManufactureId, DeviceNo = DeviceNo})
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSecureBootReq
function TGetDpuSecureBootReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
end

function TGetDpuSecureBootReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSecureBootReq.group)
end

TGetDpuSecureBootReq.from_obj = TGetDpuSecureBootReq_from_obj

TGetDpuSecureBootReq.proto_property = {'ManufactureId', 'DeviceNo'}

TGetDpuSecureBootReq.default = {0, 0}

TGetDpuSecureBootReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil}
}

function TGetDpuSecureBootReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)

    TGetDpuSecureBootReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSecureBootReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuSecureBootReq:unpack(_)
    return self.ManufactureId, self.DeviceNo
end

GetDpuSecureBoot.GetDpuSecureBootReq = TGetDpuSecureBootReq

---@class GeneralHardwareIpmiCmds.GetDpuSecureBootRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field SecureBoot integer
local TGetDpuSecureBootRsp = {}
TGetDpuSecureBootRsp.__index = TGetDpuSecureBootRsp
TGetDpuSecureBootRsp.group = {}

local function TGetDpuSecureBootRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuSecureBootRsp)
end

function TGetDpuSecureBootRsp.new(CompletionCode, ManufactureId, EndOfList, SecureBoot)
    return TGetDpuSecureBootRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        SecureBoot = SecureBoot
    })
end
---@param obj GeneralHardwareIpmiCmds.GetDpuSecureBootRsp
function TGetDpuSecureBootRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.SecureBoot = obj.SecureBoot
end

function TGetDpuSecureBootRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuSecureBootRsp.group)
end

TGetDpuSecureBootRsp.from_obj = TGetDpuSecureBootRsp_from_obj

TGetDpuSecureBootRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'SecureBoot'}

TGetDpuSecureBootRsp.default = {0, 0, 0, 0}

TGetDpuSecureBootRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'SecureBoot', is_array = false, struct = nil}
}

function TGetDpuSecureBootRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SecureBoot', self.SecureBoot, 'uint8', false, errs, need_convert)

    TGetDpuSecureBootRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuSecureBootRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuSecureBootRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.SecureBoot
end

GetDpuSecureBoot.GetDpuSecureBootRsp = TGetDpuSecureBootRsp

return GetDpuSecureBoot
