--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCpuModulePower = {}

---@class GeneralHardwareIpmiCmds.GetCpuModulePowerReq
---@field ManufactureId integer
---@field Index integer
local TGetCpuModulePowerReq = {}
TGetCpuModulePowerReq.__index = TGetCpuModulePowerReq
TGetCpuModulePowerReq.group = {}

local function TGetCpuModulePowerReq_from_obj(obj)
    return setmetatable(obj, TGetCpuModulePowerReq)
end

function TGetCpuModulePowerReq.new(ManufactureId, Index)
    return TGetCpuModulePowerReq_from_obj({ManufactureId = ManufactureId, Index = Index})
end
---@param obj GeneralHardwareIpmiCmds.GetCpuModulePowerReq
function TGetCpuModulePowerReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Index = obj.Index
end

function TGetCpuModulePowerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpuModulePowerReq.group)
end

TGetCpuModulePowerReq.from_obj = TGetCpuModulePowerReq_from_obj

TGetCpuModulePowerReq.proto_property = {'ManufactureId', 'Index'}

TGetCpuModulePowerReq.default = {0, 0}

TGetCpuModulePowerReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Index', is_array = false, struct = nil}
}

function TGetCpuModulePowerReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Index', self.Index, 'uint8', false, errs, need_convert)

    TGetCpuModulePowerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpuModulePowerReq.proto_property, errs, need_convert)
    return self
end

function TGetCpuModulePowerReq:unpack(_)
    return self.ManufactureId, self.Index
end

GetCpuModulePower.GetCpuModulePowerReq = TGetCpuModulePowerReq

---@class GeneralHardwareIpmiCmds.GetCpuModulePowerRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Power integer
local TGetCpuModulePowerRsp = {}
TGetCpuModulePowerRsp.__index = TGetCpuModulePowerRsp
TGetCpuModulePowerRsp.group = {}

local function TGetCpuModulePowerRsp_from_obj(obj)
    return setmetatable(obj, TGetCpuModulePowerRsp)
end

function TGetCpuModulePowerRsp.new(CompletionCode, ManufactureId, Power)
    return TGetCpuModulePowerRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Power = Power
    })
end
---@param obj GeneralHardwareIpmiCmds.GetCpuModulePowerRsp
function TGetCpuModulePowerRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Power = obj.Power
end

function TGetCpuModulePowerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpuModulePowerRsp.group)
end

TGetCpuModulePowerRsp.from_obj = TGetCpuModulePowerRsp_from_obj

TGetCpuModulePowerRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Power'}

TGetCpuModulePowerRsp.default = {0, 0, 0}

TGetCpuModulePowerRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Power', is_array = false, struct = nil}
}

function TGetCpuModulePowerRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Power', self.Power, 'uint32', false, errs, need_convert)

    TGetCpuModulePowerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpuModulePowerRsp.proto_property, errs, need_convert)
    return self
end

function TGetCpuModulePowerRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Power
end

GetCpuModulePower.GetCpuModulePowerRsp = TGetCpuModulePowerRsp

return GetCpuModulePower
