--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetAllDpuEPInitStatus = {}

---@class GeneralHardwareIpmiCmds.GetAllDpuEPInitStatusReq
---@field ManufactureId integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
local TGetAllDpuEPInitStatusReq = {}
TGetAllDpuEPInitStatusReq.__index = TGetAllDpuEPInitStatusReq
TGetAllDpuEPInitStatusReq.group = {}

local function TGetAllDpuEPInitStatusReq_from_obj(obj)
    return setmetatable(obj, TGetAllDpuEPInitStatusReq)
end

function TGetAllDpuEPInitStatusReq.new(ManufactureId, DeviceNo, Offset, Length)
    return TGetAllDpuEPInitStatusReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length
    })
end
---@param obj GeneralHardwareIpmiCmds.GetAllDpuEPInitStatusReq
function TGetAllDpuEPInitStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetAllDpuEPInitStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllDpuEPInitStatusReq.group)
end

TGetAllDpuEPInitStatusReq.from_obj = TGetAllDpuEPInitStatusReq_from_obj

TGetAllDpuEPInitStatusReq.proto_property = {'ManufactureId', 'DeviceNo', 'Offset', 'Length'}

TGetAllDpuEPInitStatusReq.default = {0, 0, 0, 0}

TGetAllDpuEPInitStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNo', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetAllDpuEPInitStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetAllDpuEPInitStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllDpuEPInitStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetAllDpuEPInitStatusReq:unpack(_)
    return self.ManufactureId, self.DeviceNo, self.Offset, self.Length
end

GetAllDpuEPInitStatus.GetAllDpuEPInitStatusReq = TGetAllDpuEPInitStatusReq

---@class GeneralHardwareIpmiCmds.GetAllDpuEPInitStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field EPInitStatus integer
local TGetAllDpuEPInitStatusRsp = {}
TGetAllDpuEPInitStatusRsp.__index = TGetAllDpuEPInitStatusRsp
TGetAllDpuEPInitStatusRsp.group = {}

local function TGetAllDpuEPInitStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetAllDpuEPInitStatusRsp)
end

function TGetAllDpuEPInitStatusRsp.new(CompletionCode, ManufactureId, EndOfList, EPInitStatus)
    return TGetAllDpuEPInitStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        EPInitStatus = EPInitStatus
    })
end
---@param obj GeneralHardwareIpmiCmds.GetAllDpuEPInitStatusRsp
function TGetAllDpuEPInitStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.EPInitStatus = obj.EPInitStatus
end

function TGetAllDpuEPInitStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllDpuEPInitStatusRsp.group)
end

TGetAllDpuEPInitStatusRsp.from_obj = TGetAllDpuEPInitStatusRsp_from_obj

TGetAllDpuEPInitStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'EPInitStatus'}

TGetAllDpuEPInitStatusRsp.default = {0, 0, 0, 0}

TGetAllDpuEPInitStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'EPInitStatus', is_array = false, struct = nil}
}

function TGetAllDpuEPInitStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EPInitStatus', self.EPInitStatus, 'uint8', false, errs, need_convert)

    TGetAllDpuEPInitStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllDpuEPInitStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetAllDpuEPInitStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.EPInitStatus
end

GetAllDpuEPInitStatus.GetAllDpuEPInitStatusRsp = TGetAllDpuEPInitStatusRsp

return GetAllDpuEPInitStatus
