-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSRUpgrade = {}

---@class MSRUpgrade.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MSRUpgrade.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MSRUpgrade.Version = TVersion

---@class MSRUpgrade.WriteProtectLockChip
---@field WriteProtectLockChip integer[]
local TWriteProtectLockChip = {}
TWriteProtectLockChip.__index = TWriteProtectLockChip
TWriteProtectLockChip.group = {}

local function TWriteProtectLockChip_from_obj(obj)
    return setmetatable(obj, TWriteProtectLockChip)
end

function TWriteProtectLockChip.new(WriteProtectLockChip)
    return TWriteProtectLockChip_from_obj({WriteProtectLockChip = WriteProtectLockChip})
end
---@param obj MSRUpgrade.WriteProtectLockChip
function TWriteProtectLockChip:init_from_obj(obj)
    self.WriteProtectLockChip = obj.WriteProtectLockChip
end

function TWriteProtectLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteProtectLockChip.group)
end

TWriteProtectLockChip.from_obj = TWriteProtectLockChip_from_obj

TWriteProtectLockChip.proto_property = {'WriteProtectLockChip'}

TWriteProtectLockChip.default = {{}}

TWriteProtectLockChip.struct = {{name = 'WriteProtectLockChip', is_array = true, struct = nil}}

function TWriteProtectLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'WriteProtectLockChip', self.WriteProtectLockChip, 'uint8', false, errs,
        need_convert)

    TWriteProtectLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteProtectLockChip.proto_property, errs, need_convert)
    return self
end

function TWriteProtectLockChip:unpack(_)
    return self.WriteProtectLockChip
end

MSRUpgrade.WriteProtectLockChip = TWriteProtectLockChip

---@class MSRUpgrade.WriteProtectChip
---@field WriteProtectChip integer[]
local TWriteProtectChip = {}
TWriteProtectChip.__index = TWriteProtectChip
TWriteProtectChip.group = {}

local function TWriteProtectChip_from_obj(obj)
    return setmetatable(obj, TWriteProtectChip)
end

function TWriteProtectChip.new(WriteProtectChip)
    return TWriteProtectChip_from_obj({WriteProtectChip = WriteProtectChip})
end
---@param obj MSRUpgrade.WriteProtectChip
function TWriteProtectChip:init_from_obj(obj)
    self.WriteProtectChip = obj.WriteProtectChip
end

function TWriteProtectChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteProtectChip.group)
end

TWriteProtectChip.from_obj = TWriteProtectChip_from_obj

TWriteProtectChip.proto_property = {'WriteProtectChip'}

TWriteProtectChip.default = {{}}

TWriteProtectChip.struct = {{name = 'WriteProtectChip', is_array = true, struct = nil}}

function TWriteProtectChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'WriteProtectChip', self.WriteProtectChip, 'uint8', false, errs, need_convert)

    TWriteProtectChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteProtectChip.proto_property, errs, need_convert)
    return self
end

function TWriteProtectChip:unpack(_)
    return self.WriteProtectChip
end

MSRUpgrade.WriteProtectChip = TWriteProtectChip

---@class MSRUpgrade.WriteProtect
---@field WriteProtect integer
local TWriteProtect = {}
TWriteProtect.__index = TWriteProtect
TWriteProtect.group = {}

local function TWriteProtect_from_obj(obj)
    return setmetatable(obj, TWriteProtect)
end

function TWriteProtect.new(WriteProtect)
    return TWriteProtect_from_obj({WriteProtect = WriteProtect})
end
---@param obj MSRUpgrade.WriteProtect
function TWriteProtect:init_from_obj(obj)
    self.WriteProtect = obj.WriteProtect
end

function TWriteProtect:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteProtect.group)
end

TWriteProtect.from_obj = TWriteProtect_from_obj

TWriteProtect.proto_property = {'WriteProtect'}

TWriteProtect.default = {0}

TWriteProtect.struct = {{name = 'WriteProtect', is_array = false, struct = nil}}

function TWriteProtect:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WriteProtect', self.WriteProtect, 'uint8', false, errs, need_convert)

    TWriteProtect:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteProtect.proto_property, errs, need_convert)
    return self
end

function TWriteProtect:unpack(_)
    return self.WriteProtect
end

MSRUpgrade.WriteProtect = TWriteProtect

---@class MSRUpgrade.StorageLockChip
---@field StorageLockChip integer[]
local TStorageLockChip = {}
TStorageLockChip.__index = TStorageLockChip
TStorageLockChip.group = {}

local function TStorageLockChip_from_obj(obj)
    return setmetatable(obj, TStorageLockChip)
end

function TStorageLockChip.new(StorageLockChip)
    return TStorageLockChip_from_obj({StorageLockChip = StorageLockChip})
end
---@param obj MSRUpgrade.StorageLockChip
function TStorageLockChip:init_from_obj(obj)
    self.StorageLockChip = obj.StorageLockChip
end

function TStorageLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageLockChip.group)
end

TStorageLockChip.from_obj = TStorageLockChip_from_obj

TStorageLockChip.proto_property = {'StorageLockChip'}

TStorageLockChip.default = {{}}

TStorageLockChip.struct = {{name = 'StorageLockChip', is_array = true, struct = nil}}

function TStorageLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'StorageLockChip', self.StorageLockChip, 'uint8', false, errs, need_convert)

    TStorageLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageLockChip.proto_property, errs, need_convert)
    return self
end

function TStorageLockChip:unpack(_)
    return self.StorageLockChip
end

MSRUpgrade.StorageLockChip = TStorageLockChip

---@class MSRUpgrade.StorageChip
---@field StorageChip integer[]
local TStorageChip = {}
TStorageChip.__index = TStorageChip
TStorageChip.group = {}

local function TStorageChip_from_obj(obj)
    return setmetatable(obj, TStorageChip)
end

function TStorageChip.new(StorageChip)
    return TStorageChip_from_obj({StorageChip = StorageChip})
end
---@param obj MSRUpgrade.StorageChip
function TStorageChip:init_from_obj(obj)
    self.StorageChip = obj.StorageChip
end

function TStorageChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageChip.group)
end

TStorageChip.from_obj = TStorageChip_from_obj

TStorageChip.proto_property = {'StorageChip'}

TStorageChip.default = {{}}

TStorageChip.struct = {{name = 'StorageChip', is_array = true, struct = nil}}

function TStorageChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'StorageChip', self.StorageChip, 'uint8', false, errs, need_convert)

    TStorageChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageChip.proto_property, errs, need_convert)
    return self
end

function TStorageChip:unpack(_)
    return self.StorageChip
end

MSRUpgrade.StorageChip = TStorageChip

---@class MSRUpgrade.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MSRUpgrade.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MSRUpgrade.Type = TType

---@class MSRUpgrade.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj MSRUpgrade.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MSRUpgrade.SoftwareId = TSoftwareId

---@class MSRUpgrade.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MSRUpgrade.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MSRUpgrade.UID = TUID

return MSRUpgrade
