-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MMCUFirmware = {}

---@class MMCUFirmware.BoardType
---@field BoardType string
local TBoardType = {}
TBoardType.__index = TBoardType
TBoardType.group = {}

local function TBoardType_from_obj(obj)
    return setmetatable(obj, TBoardType)
end

function TBoardType.new(BoardType)
    return TBoardType_from_obj({BoardType = BoardType})
end
---@param obj MMCUFirmware.BoardType
function TBoardType:init_from_obj(obj)
    self.BoardType = obj.BoardType
end

function TBoardType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardType.group)
end

TBoardType.from_obj = TBoardType_from_obj

TBoardType.proto_property = {'BoardType'}

TBoardType.default = {''}

TBoardType.struct = {{name = 'BoardType', is_array = false, struct = nil}}

function TBoardType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardType', self.BoardType, 'string', false, errs, need_convert)

    TBoardType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardType.proto_property, errs, need_convert)
    return self
end

function TBoardType:unpack(_)
    return self.BoardType
end

MMCUFirmware.BoardType = TBoardType

---@class MMCUFirmware.SubCompList
---@field SubCompList def_types.SubCompItem[]
local TSubCompList = {}
TSubCompList.__index = TSubCompList
TSubCompList.group = {}

local function TSubCompList_from_obj(obj)
    obj.SubCompList = utils.from_obj(def_types.SubCompItem, obj.SubCompList, true)
    return setmetatable(obj, TSubCompList)
end

function TSubCompList.new(SubCompList)
    return TSubCompList_from_obj({SubCompList = SubCompList})
end
---@param obj MMCUFirmware.SubCompList
function TSubCompList:init_from_obj(obj)
    self.SubCompList = obj.SubCompList
end

function TSubCompList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubCompList.group)
end

TSubCompList.from_obj = TSubCompList_from_obj

TSubCompList.proto_property = {'SubCompList'}

TSubCompList.default = {{}}

TSubCompList.struct = {{name = 'SubCompList', is_array = true, struct = def_types.SubCompItem.struct}}

function TSubCompList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SubCompList) do
        def_types.SubCompItem.new(v.Index, v.Type, v.No, v.Vendor, v.SKU, v.MajorVersion, v.MinorVersion, v.Revision):validate(
            prefix, errs, need_convert)
    end

    TSubCompList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubCompList.proto_property, errs, need_convert)
    return self
end

function TSubCompList:unpack(raw)
    return utils.unpack(raw, self.SubCompList, true)
end

MMCUFirmware.SubCompList = TSubCompList

---@class MMCUFirmware.BinMaxSize
---@field BinMaxSize integer
local TBinMaxSize = {}
TBinMaxSize.__index = TBinMaxSize
TBinMaxSize.group = {}

local function TBinMaxSize_from_obj(obj)
    return setmetatable(obj, TBinMaxSize)
end

function TBinMaxSize.new(BinMaxSize)
    return TBinMaxSize_from_obj({BinMaxSize = BinMaxSize})
end
---@param obj MMCUFirmware.BinMaxSize
function TBinMaxSize:init_from_obj(obj)
    self.BinMaxSize = obj.BinMaxSize
end

function TBinMaxSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBinMaxSize.group)
end

TBinMaxSize.from_obj = TBinMaxSize_from_obj

TBinMaxSize.proto_property = {'BinMaxSize'}

TBinMaxSize.default = {0}

TBinMaxSize.struct = {{name = 'BinMaxSize', is_array = false, struct = nil}}

function TBinMaxSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BinMaxSize', self.BinMaxSize, 'uint32', false, errs, need_convert)

    TBinMaxSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBinMaxSize.proto_property, errs, need_convert)
    return self
end

function TBinMaxSize:unpack(_)
    return self.BinMaxSize
end

MMCUFirmware.BinMaxSize = TBinMaxSize

---@class MMCUFirmware.LibMaxSize
---@field LibMaxSize integer
local TLibMaxSize = {}
TLibMaxSize.__index = TLibMaxSize
TLibMaxSize.group = {}

local function TLibMaxSize_from_obj(obj)
    return setmetatable(obj, TLibMaxSize)
end

function TLibMaxSize.new(LibMaxSize)
    return TLibMaxSize_from_obj({LibMaxSize = LibMaxSize})
end
---@param obj MMCUFirmware.LibMaxSize
function TLibMaxSize:init_from_obj(obj)
    self.LibMaxSize = obj.LibMaxSize
end

function TLibMaxSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLibMaxSize.group)
end

TLibMaxSize.from_obj = TLibMaxSize_from_obj

TLibMaxSize.proto_property = {'LibMaxSize'}

TLibMaxSize.default = {0}

TLibMaxSize.struct = {{name = 'LibMaxSize', is_array = false, struct = nil}}

function TLibMaxSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LibMaxSize', self.LibMaxSize, 'uint32', false, errs, need_convert)

    TLibMaxSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLibMaxSize.proto_property, errs, need_convert)
    return self
end

function TLibMaxSize:unpack(_)
    return self.LibMaxSize
end

MMCUFirmware.LibMaxSize = TLibMaxSize

---@class MMCUFirmware.Revision
---@field Revision string
local TRevision = {}
TRevision.__index = TRevision
TRevision.group = {}

local function TRevision_from_obj(obj)
    return setmetatable(obj, TRevision)
end

function TRevision.new(Revision)
    return TRevision_from_obj({Revision = Revision})
end
---@param obj MMCUFirmware.Revision
function TRevision:init_from_obj(obj)
    self.Revision = obj.Revision
end

function TRevision:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevision.group)
end

TRevision.from_obj = TRevision_from_obj

TRevision.proto_property = {'Revision'}

TRevision.default = {''}

TRevision.struct = {{name = 'Revision', is_array = false, struct = nil}}

function TRevision:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Revision', self.Revision, 'string', false, errs, need_convert)

    TRevision:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevision.proto_property, errs, need_convert)
    return self
end

function TRevision:unpack(_)
    return self.Revision
end

MMCUFirmware.Revision = TRevision

---@class MMCUFirmware.MinorVersion
---@field MinorVersion string
local TMinorVersion = {}
TMinorVersion.__index = TMinorVersion
TMinorVersion.group = {}

local function TMinorVersion_from_obj(obj)
    return setmetatable(obj, TMinorVersion)
end

function TMinorVersion.new(MinorVersion)
    return TMinorVersion_from_obj({MinorVersion = MinorVersion})
end
---@param obj MMCUFirmware.MinorVersion
function TMinorVersion:init_from_obj(obj)
    self.MinorVersion = obj.MinorVersion
end

function TMinorVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinorVersion.group)
end

TMinorVersion.from_obj = TMinorVersion_from_obj

TMinorVersion.proto_property = {'MinorVersion'}

TMinorVersion.default = {''}

TMinorVersion.struct = {{name = 'MinorVersion', is_array = false, struct = nil}}

function TMinorVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinorVersion', self.MinorVersion, 'string', false, errs, need_convert)

    TMinorVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinorVersion.proto_property, errs, need_convert)
    return self
end

function TMinorVersion:unpack(_)
    return self.MinorVersion
end

MMCUFirmware.MinorVersion = TMinorVersion

---@class MMCUFirmware.MajorVersion
---@field MajorVersion string
local TMajorVersion = {}
TMajorVersion.__index = TMajorVersion
TMajorVersion.group = {}

local function TMajorVersion_from_obj(obj)
    return setmetatable(obj, TMajorVersion)
end

function TMajorVersion.new(MajorVersion)
    return TMajorVersion_from_obj({MajorVersion = MajorVersion})
end
---@param obj MMCUFirmware.MajorVersion
function TMajorVersion:init_from_obj(obj)
    self.MajorVersion = obj.MajorVersion
end

function TMajorVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMajorVersion.group)
end

TMajorVersion.from_obj = TMajorVersion_from_obj

TMajorVersion.proto_property = {'MajorVersion'}

TMajorVersion.default = {''}

TMajorVersion.struct = {{name = 'MajorVersion', is_array = false, struct = nil}}

function TMajorVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MajorVersion', self.MajorVersion, 'string', false, errs, need_convert)

    TMajorVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMajorVersion.proto_property, errs, need_convert)
    return self
end

function TMajorVersion:unpack(_)
    return self.MajorVersion
end

MMCUFirmware.MajorVersion = TMajorVersion

---@class MMCUFirmware.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MMCUFirmware.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MMCUFirmware.Id = TId

---@class MMCUFirmware.Protocol
---@field Protocol string
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol})
end
---@param obj MMCUFirmware.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {''}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'string', false, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

MMCUFirmware.Protocol = TProtocol

---@class MMCUFirmware.Address
---@field Address integer
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address})
end
---@param obj MMCUFirmware.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {0}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address', self.Address, 'uint32', false, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

MMCUFirmware.Address = TAddress

---@class MMCUFirmware.LockChip
---@field LockChip integer[]
local TLockChip = {}
TLockChip.__index = TLockChip
TLockChip.group = {}

local function TLockChip_from_obj(obj)
    return setmetatable(obj, TLockChip)
end

function TLockChip.new(LockChip)
    return TLockChip_from_obj({LockChip = LockChip})
end
---@param obj MMCUFirmware.LockChip
function TLockChip:init_from_obj(obj)
    self.LockChip = obj.LockChip
end

function TLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLockChip.group)
end

TLockChip.from_obj = TLockChip_from_obj

TLockChip.proto_property = {'LockChip'}

TLockChip.default = {{}}

TLockChip.struct = {{name = 'LockChip', is_array = true, struct = nil}}

function TLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LockChip', self.LockChip, 'uint8', false, errs, need_convert)

    TLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLockChip.proto_property, errs, need_convert)
    return self
end

function TLockChip:unpack(_)
    return self.LockChip
end

MMCUFirmware.LockChip = TLockChip

---@class MMCUFirmware.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MMCUFirmware.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MMCUFirmware.RefChip = TRefChip

---@class MMCUFirmware.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj MMCUFirmware.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MMCUFirmware.SoftwareId = TSoftwareId

---@class MMCUFirmware.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MMCUFirmware.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MMCUFirmware.UID = TUID

return MMCUFirmware
