-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLogicFirmware = {}

---@class MLogicFirmware.FpgaCount
---@field FpgaCount integer
local TFpgaCount = {}
TFpgaCount.__index = TFpgaCount
TFpgaCount.group = {}

local function TFpgaCount_from_obj(obj)
    return setmetatable(obj, TFpgaCount)
end

function TFpgaCount.new(FpgaCount)
    return TFpgaCount_from_obj({FpgaCount = FpgaCount or 0})
end
---@param obj MLogicFirmware.FpgaCount
function TFpgaCount:init_from_obj(obj)
    self.FpgaCount = obj.FpgaCount or 0
end

function TFpgaCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFpgaCount.group)
end

TFpgaCount.from_obj = TFpgaCount_from_obj

TFpgaCount.proto_property = {'FpgaCount'}

TFpgaCount.default = {0}

TFpgaCount.struct = {{name = 'FpgaCount', is_array = false, struct = nil}}

function TFpgaCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FpgaCount', self.FpgaCount, 'uint8', false, errs, need_convert)

    TFpgaCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFpgaCount.proto_property, errs, need_convert)
    return self
end

function TFpgaCount:unpack(_)
    return self.FpgaCount
end

MLogicFirmware.FpgaCount = TFpgaCount

---@class MLogicFirmware.FpgaTestRegW
---@field FpgaTestRegW integer
local TFpgaTestRegW = {}
TFpgaTestRegW.__index = TFpgaTestRegW
TFpgaTestRegW.group = {}

local function TFpgaTestRegW_from_obj(obj)
    return setmetatable(obj, TFpgaTestRegW)
end

function TFpgaTestRegW.new(FpgaTestRegW)
    return TFpgaTestRegW_from_obj({FpgaTestRegW = FpgaTestRegW})
end
---@param obj MLogicFirmware.FpgaTestRegW
function TFpgaTestRegW:init_from_obj(obj)
    self.FpgaTestRegW = obj.FpgaTestRegW
end

function TFpgaTestRegW:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFpgaTestRegW.group)
end

TFpgaTestRegW.from_obj = TFpgaTestRegW_from_obj

TFpgaTestRegW.proto_property = {'FpgaTestRegW'}

TFpgaTestRegW.default = {0}

TFpgaTestRegW.struct = {{name = 'FpgaTestRegW', is_array = false, struct = nil}}

function TFpgaTestRegW:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FpgaTestRegW', self.FpgaTestRegW, 'uint32', false, errs, need_convert)

    TFpgaTestRegW:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFpgaTestRegW.proto_property, errs, need_convert)
    return self
end

function TFpgaTestRegW:unpack(_)
    return self.FpgaTestRegW
end

MLogicFirmware.FpgaTestRegW = TFpgaTestRegW

---@class MLogicFirmware.FpgaTestRegR
---@field FpgaTestRegR integer
local TFpgaTestRegR = {}
TFpgaTestRegR.__index = TFpgaTestRegR
TFpgaTestRegR.group = {}

local function TFpgaTestRegR_from_obj(obj)
    return setmetatable(obj, TFpgaTestRegR)
end

function TFpgaTestRegR.new(FpgaTestRegR)
    return TFpgaTestRegR_from_obj({FpgaTestRegR = FpgaTestRegR})
end
---@param obj MLogicFirmware.FpgaTestRegR
function TFpgaTestRegR:init_from_obj(obj)
    self.FpgaTestRegR = obj.FpgaTestRegR
end

function TFpgaTestRegR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFpgaTestRegR.group)
end

TFpgaTestRegR.from_obj = TFpgaTestRegR_from_obj

TFpgaTestRegR.proto_property = {'FpgaTestRegR'}

TFpgaTestRegR.default = {0}

TFpgaTestRegR.struct = {{name = 'FpgaTestRegR', is_array = false, struct = nil}}

function TFpgaTestRegR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FpgaTestRegR', self.FpgaTestRegR, 'uint32', false, errs, need_convert)

    TFpgaTestRegR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFpgaTestRegR.proto_property, errs, need_convert)
    return self
end

function TFpgaTestRegR:unpack(_)
    return self.FpgaTestRegR
end

MLogicFirmware.FpgaTestRegR = TFpgaTestRegR

---@class MLogicFirmware.ComponentIDEx
---@field ComponentIDEx integer
local TComponentIDEx = {}
TComponentIDEx.__index = TComponentIDEx
TComponentIDEx.group = {}

local function TComponentIDEx_from_obj(obj)
    return setmetatable(obj, TComponentIDEx)
end

function TComponentIDEx.new(ComponentIDEx)
    return TComponentIDEx_from_obj({ComponentIDEx = ComponentIDEx or 4294967295})
end
---@param obj MLogicFirmware.ComponentIDEx
function TComponentIDEx:init_from_obj(obj)
    self.ComponentIDEx = obj.ComponentIDEx or 4294967295
end

function TComponentIDEx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentIDEx.group)
end

TComponentIDEx.from_obj = TComponentIDEx_from_obj

TComponentIDEx.proto_property = {'ComponentIDEx'}

TComponentIDEx.default = {0}

TComponentIDEx.struct = {{name = 'ComponentIDEx', is_array = false, struct = nil}}

function TComponentIDEx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentIDEx', self.ComponentIDEx, 'uint32', false, errs, need_convert)

    TComponentIDEx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentIDEx.proto_property, errs, need_convert)
    return self
end

function TComponentIDEx:unpack(_)
    return self.ComponentIDEx
end

MLogicFirmware.ComponentIDEx = TComponentIDEx

---@class MLogicFirmware.ComponentID
---@field ComponentID integer
local TComponentID = {}
TComponentID.__index = TComponentID
TComponentID.group = {}

local function TComponentID_from_obj(obj)
    return setmetatable(obj, TComponentID)
end

function TComponentID.new(ComponentID)
    return TComponentID_from_obj({ComponentID = ComponentID or 255})
end
---@param obj MLogicFirmware.ComponentID
function TComponentID:init_from_obj(obj)
    self.ComponentID = obj.ComponentID or 255
end

function TComponentID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentID.group)
end

TComponentID.from_obj = TComponentID_from_obj

TComponentID.proto_property = {'ComponentID'}

TComponentID.default = {0}

TComponentID.struct = {{name = 'ComponentID', is_array = false, struct = nil}}

function TComponentID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentID', self.ComponentID, 'uint8', false, errs, need_convert)

    TComponentID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentID.proto_property, errs, need_convert)
    return self
end

function TComponentID:unpack(_)
    return self.ComponentID
end

MLogicFirmware.ComponentID = TComponentID

---@class MLogicFirmware.ComponentSlot
---@field ComponentSlot integer
local TComponentSlot = {}
TComponentSlot.__index = TComponentSlot
TComponentSlot.group = {}

local function TComponentSlot_from_obj(obj)
    return setmetatable(obj, TComponentSlot)
end

function TComponentSlot.new(ComponentSlot)
    return TComponentSlot_from_obj({ComponentSlot = ComponentSlot})
end
---@param obj MLogicFirmware.ComponentSlot
function TComponentSlot:init_from_obj(obj)
    self.ComponentSlot = obj.ComponentSlot
end

function TComponentSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentSlot.group)
end

TComponentSlot.from_obj = TComponentSlot_from_obj

TComponentSlot.proto_property = {'ComponentSlot'}

TComponentSlot.default = {0}

TComponentSlot.struct = {{name = 'ComponentSlot', is_array = false, struct = nil}}

function TComponentSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentSlot', self.ComponentSlot, 'uint8', false, errs, need_convert)

    TComponentSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentSlot.proto_property, errs, need_convert)
    return self
end

function TComponentSlot:unpack(_)
    return self.ComponentSlot
end

MLogicFirmware.ComponentSlot = TComponentSlot

---@class MLogicFirmware.ComponentType
---@field ComponentType integer
local TComponentType = {}
TComponentType.__index = TComponentType
TComponentType.group = {}

local function TComponentType_from_obj(obj)
    return setmetatable(obj, TComponentType)
end

function TComponentType.new(ComponentType)
    return TComponentType_from_obj({ComponentType = ComponentType})
end
---@param obj MLogicFirmware.ComponentType
function TComponentType:init_from_obj(obj)
    self.ComponentType = obj.ComponentType
end

function TComponentType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentType.group)
end

TComponentType.from_obj = TComponentType_from_obj

TComponentType.proto_property = {'ComponentType'}

TComponentType.default = {0}

TComponentType.struct = {{name = 'ComponentType', is_array = false, struct = nil}}

function TComponentType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentType', self.ComponentType, 'uint8', false, errs, need_convert)

    TComponentType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentType.proto_property, errs, need_convert)
    return self
end

function TComponentType:unpack(_)
    return self.ComponentType
end

MLogicFirmware.ComponentType = TComponentType

---@class MLogicFirmware.DeviceID
---@field DeviceID integer[]
local TDeviceID = {}
TDeviceID.__index = TDeviceID
TDeviceID.group = {}

local function TDeviceID_from_obj(obj)
    return setmetatable(obj, TDeviceID)
end

function TDeviceID.new(DeviceID)
    return TDeviceID_from_obj({DeviceID = DeviceID})
end
---@param obj MLogicFirmware.DeviceID
function TDeviceID:init_from_obj(obj)
    self.DeviceID = obj.DeviceID
end

function TDeviceID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceID.group)
end

TDeviceID.from_obj = TDeviceID_from_obj

TDeviceID.proto_property = {'DeviceID'}

TDeviceID.default = {{}}

TDeviceID.struct = {{name = 'DeviceID', is_array = true, struct = nil}}

function TDeviceID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DeviceID', self.DeviceID, 'uint8', false, errs, need_convert)

    TDeviceID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceID.proto_property, errs, need_convert)
    return self
end

function TDeviceID:unpack(_)
    return self.DeviceID
end

MLogicFirmware.DeviceID = TDeviceID

---@class MLogicFirmware.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId or 1})
end
---@param obj MLogicFirmware.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId or 1
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MLogicFirmware.SystemId = TSystemId

---@class MLogicFirmware.ValidAction
---@field ValidAction integer
local TValidAction = {}
TValidAction.__index = TValidAction
TValidAction.group = {}

local function TValidAction_from_obj(obj)
    return setmetatable(obj, TValidAction)
end

function TValidAction.new(ValidAction)
    return TValidAction_from_obj({ValidAction = ValidAction})
end
---@param obj MLogicFirmware.ValidAction
function TValidAction:init_from_obj(obj)
    self.ValidAction = obj.ValidAction
end

function TValidAction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidAction.group)
end

TValidAction.from_obj = TValidAction_from_obj

TValidAction.proto_property = {'ValidAction'}

TValidAction.default = {0}

TValidAction.struct = {{name = 'ValidAction', is_array = false, struct = nil}}

function TValidAction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidAction', self.ValidAction, 'uint8', false, errs, need_convert)

    TValidAction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidAction.proto_property, errs, need_convert)
    return self
end

function TValidAction:unpack(_)
    return self.ValidAction
end

MLogicFirmware.ValidAction = TValidAction

---@class MLogicFirmware.ValidMode
---@field ValidMode integer
local TValidMode = {}
TValidMode.__index = TValidMode
TValidMode.group = {}

local function TValidMode_from_obj(obj)
    return setmetatable(obj, TValidMode)
end

function TValidMode.new(ValidMode)
    return TValidMode_from_obj({ValidMode = ValidMode})
end
---@param obj MLogicFirmware.ValidMode
function TValidMode:init_from_obj(obj)
    self.ValidMode = obj.ValidMode
end

function TValidMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidMode.group)
end

TValidMode.from_obj = TValidMode_from_obj

TValidMode.proto_property = {'ValidMode'}

TValidMode.default = {0}

TValidMode.struct = {{name = 'ValidMode', is_array = false, struct = nil}}

function TValidMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidMode', self.ValidMode, 'uint8', false, errs, need_convert)

    TValidMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidMode.proto_property, errs, need_convert)
    return self
end

function TValidMode:unpack(_)
    return self.ValidMode
end

MLogicFirmware.ValidMode = TValidMode

---@class MLogicFirmware.FirmwareRoute
---@field FirmwareRoute integer
local TFirmwareRoute = {}
TFirmwareRoute.__index = TFirmwareRoute
TFirmwareRoute.group = {}

local function TFirmwareRoute_from_obj(obj)
    return setmetatable(obj, TFirmwareRoute)
end

function TFirmwareRoute.new(FirmwareRoute)
    return TFirmwareRoute_from_obj({FirmwareRoute = FirmwareRoute})
end
---@param obj MLogicFirmware.FirmwareRoute
function TFirmwareRoute:init_from_obj(obj)
    self.FirmwareRoute = obj.FirmwareRoute
end

function TFirmwareRoute:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareRoute.group)
end

TFirmwareRoute.from_obj = TFirmwareRoute_from_obj

TFirmwareRoute.proto_property = {'FirmwareRoute'}

TFirmwareRoute.default = {0}

TFirmwareRoute.struct = {{name = 'FirmwareRoute', is_array = false, struct = nil}}

function TFirmwareRoute:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareRoute', self.FirmwareRoute, 'uint8', false, errs, need_convert)

    TFirmwareRoute:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareRoute.proto_property, errs, need_convert)
    return self
end

function TFirmwareRoute:unpack(_)
    return self.FirmwareRoute
end

MLogicFirmware.FirmwareRoute = TFirmwareRoute

---@class MLogicFirmware.DefaultRoute
---@field DefaultRoute integer
local TDefaultRoute = {}
TDefaultRoute.__index = TDefaultRoute
TDefaultRoute.group = {}

local function TDefaultRoute_from_obj(obj)
    return setmetatable(obj, TDefaultRoute)
end

function TDefaultRoute.new(DefaultRoute)
    return TDefaultRoute_from_obj({DefaultRoute = DefaultRoute})
end
---@param obj MLogicFirmware.DefaultRoute
function TDefaultRoute:init_from_obj(obj)
    self.DefaultRoute = obj.DefaultRoute
end

function TDefaultRoute:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultRoute.group)
end

TDefaultRoute.from_obj = TDefaultRoute_from_obj

TDefaultRoute.proto_property = {'DefaultRoute'}

TDefaultRoute.default = {0}

TDefaultRoute.struct = {{name = 'DefaultRoute', is_array = false, struct = nil}}

function TDefaultRoute:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultRoute', self.DefaultRoute, 'uint8', false, errs, need_convert)

    TDefaultRoute:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultRoute.proto_property, errs, need_convert)
    return self
end

function TDefaultRoute:unpack(_)
    return self.DefaultRoute
end

MLogicFirmware.DefaultRoute = TDefaultRoute

---@class MLogicFirmware.Routes
---@field Routes integer
local TRoutes = {}
TRoutes.__index = TRoutes
TRoutes.group = {}

local function TRoutes_from_obj(obj)
    return setmetatable(obj, TRoutes)
end

function TRoutes.new(Routes)
    return TRoutes_from_obj({Routes = Routes or 255})
end
---@param obj MLogicFirmware.Routes
function TRoutes:init_from_obj(obj)
    self.Routes = obj.Routes or 255
end

function TRoutes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRoutes.group)
end

TRoutes.from_obj = TRoutes_from_obj

TRoutes.proto_property = {'Routes'}

TRoutes.default = {0}

TRoutes.struct = {{name = 'Routes', is_array = false, struct = nil}}

function TRoutes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Routes', self.Routes, 'uint8', false, errs, need_convert)

    TRoutes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRoutes.proto_property, errs, need_convert)
    return self
end

function TRoutes:unpack(_)
    return self.Routes
end

MLogicFirmware.Routes = TRoutes

---@class MLogicFirmware.ChipInfo
---@field ChipInfo integer[]
local TChipInfo = {}
TChipInfo.__index = TChipInfo
TChipInfo.group = {}

local function TChipInfo_from_obj(obj)
    return setmetatable(obj, TChipInfo)
end

function TChipInfo.new(ChipInfo)
    return TChipInfo_from_obj({ChipInfo = ChipInfo})
end
---@param obj MLogicFirmware.ChipInfo
function TChipInfo:init_from_obj(obj)
    self.ChipInfo = obj.ChipInfo
end

function TChipInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipInfo.group)
end

TChipInfo.from_obj = TChipInfo_from_obj

TChipInfo.proto_property = {'ChipInfo'}

TChipInfo.default = {{}}

TChipInfo.struct = {{name = 'ChipInfo', is_array = true, struct = nil}}

function TChipInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'ChipInfo', self.ChipInfo, 'uint8', false, errs, need_convert)

    TChipInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipInfo.proto_property, errs, need_convert)
    return self
end

function TChipInfo:unpack(_)
    return self.ChipInfo
end

MLogicFirmware.ChipInfo = TChipInfo

---@class MLogicFirmware.UpgradeLockChip
---@field UpgradeLockChip integer[]
local TUpgradeLockChip = {}
TUpgradeLockChip.__index = TUpgradeLockChip
TUpgradeLockChip.group = {}

local function TUpgradeLockChip_from_obj(obj)
    return setmetatable(obj, TUpgradeLockChip)
end

function TUpgradeLockChip.new(UpgradeLockChip)
    return TUpgradeLockChip_from_obj({UpgradeLockChip = UpgradeLockChip})
end
---@param obj MLogicFirmware.UpgradeLockChip
function TUpgradeLockChip:init_from_obj(obj)
    self.UpgradeLockChip = obj.UpgradeLockChip
end

function TUpgradeLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeLockChip.group)
end

TUpgradeLockChip.from_obj = TUpgradeLockChip_from_obj

TUpgradeLockChip.proto_property = {'UpgradeLockChip'}

TUpgradeLockChip.default = {{}}

TUpgradeLockChip.struct = {{name = 'UpgradeLockChip', is_array = true, struct = nil}}

function TUpgradeLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'UpgradeLockChip', self.UpgradeLockChip, 'uint8', false, errs, need_convert)

    TUpgradeLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeLockChip.proto_property, errs, need_convert)
    return self
end

function TUpgradeLockChip:unpack(_)
    return self.UpgradeLockChip
end

MLogicFirmware.UpgradeLockChip = TUpgradeLockChip

---@class MLogicFirmware.UpgradeChip
---@field UpgradeChip integer[]
local TUpgradeChip = {}
TUpgradeChip.__index = TUpgradeChip
TUpgradeChip.group = {}

local function TUpgradeChip_from_obj(obj)
    return setmetatable(obj, TUpgradeChip)
end

function TUpgradeChip.new(UpgradeChip)
    return TUpgradeChip_from_obj({UpgradeChip = UpgradeChip})
end
---@param obj MLogicFirmware.UpgradeChip
function TUpgradeChip:init_from_obj(obj)
    self.UpgradeChip = obj.UpgradeChip
end

function TUpgradeChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeChip.group)
end

TUpgradeChip.from_obj = TUpgradeChip_from_obj

TUpgradeChip.proto_property = {'UpgradeChip'}

TUpgradeChip.default = {{}}

TUpgradeChip.struct = {{name = 'UpgradeChip', is_array = true, struct = nil}}

function TUpgradeChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'UpgradeChip', self.UpgradeChip, 'uint8', false, errs, need_convert)

    TUpgradeChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeChip.proto_property, errs, need_convert)
    return self
end

function TUpgradeChip:unpack(_)
    return self.UpgradeChip
end

MLogicFirmware.UpgradeChip = TUpgradeChip

---@class MLogicFirmware.I2CUpgradeLockChip
---@field I2CUpgradeLockChip integer[]
local TI2CUpgradeLockChip = {}
TI2CUpgradeLockChip.__index = TI2CUpgradeLockChip
TI2CUpgradeLockChip.group = {}

local function TI2CUpgradeLockChip_from_obj(obj)
    return setmetatable(obj, TI2CUpgradeLockChip)
end

function TI2CUpgradeLockChip.new(I2CUpgradeLockChip)
    return TI2CUpgradeLockChip_from_obj({I2CUpgradeLockChip = I2CUpgradeLockChip})
end
---@param obj MLogicFirmware.I2CUpgradeLockChip
function TI2CUpgradeLockChip:init_from_obj(obj)
    self.I2CUpgradeLockChip = obj.I2CUpgradeLockChip
end

function TI2CUpgradeLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TI2CUpgradeLockChip.group)
end

TI2CUpgradeLockChip.from_obj = TI2CUpgradeLockChip_from_obj

TI2CUpgradeLockChip.proto_property = {'I2CUpgradeLockChip'}

TI2CUpgradeLockChip.default = {{}}

TI2CUpgradeLockChip.struct = {{name = 'I2CUpgradeLockChip', is_array = true, struct = nil}}

function TI2CUpgradeLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'I2CUpgradeLockChip', self.I2CUpgradeLockChip, 'uint8', false, errs, need_convert)

    TI2CUpgradeLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TI2CUpgradeLockChip.proto_property, errs, need_convert)
    return self
end

function TI2CUpgradeLockChip:unpack(_)
    return self.I2CUpgradeLockChip
end

MLogicFirmware.I2CUpgradeLockChip = TI2CUpgradeLockChip

---@class MLogicFirmware.I2CUpgradeChip
---@field I2CUpgradeChip integer[]
local TI2CUpgradeChip = {}
TI2CUpgradeChip.__index = TI2CUpgradeChip
TI2CUpgradeChip.group = {}

local function TI2CUpgradeChip_from_obj(obj)
    return setmetatable(obj, TI2CUpgradeChip)
end

function TI2CUpgradeChip.new(I2CUpgradeChip)
    return TI2CUpgradeChip_from_obj({I2CUpgradeChip = I2CUpgradeChip})
end
---@param obj MLogicFirmware.I2CUpgradeChip
function TI2CUpgradeChip:init_from_obj(obj)
    self.I2CUpgradeChip = obj.I2CUpgradeChip
end

function TI2CUpgradeChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TI2CUpgradeChip.group)
end

TI2CUpgradeChip.from_obj = TI2CUpgradeChip_from_obj

TI2CUpgradeChip.proto_property = {'I2CUpgradeChip'}

TI2CUpgradeChip.default = {{}}

TI2CUpgradeChip.struct = {{name = 'I2CUpgradeChip', is_array = true, struct = nil}}

function TI2CUpgradeChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'I2CUpgradeChip', self.I2CUpgradeChip, 'uint8', false, errs, need_convert)

    TI2CUpgradeChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TI2CUpgradeChip.proto_property, errs, need_convert)
    return self
end

function TI2CUpgradeChip:unpack(_)
    return self.I2CUpgradeChip
end

MLogicFirmware.I2CUpgradeChip = TI2CUpgradeChip

---@class MLogicFirmware.SmcChip
---@field SmcChip integer[]
local TSmcChip = {}
TSmcChip.__index = TSmcChip
TSmcChip.group = {}

local function TSmcChip_from_obj(obj)
    return setmetatable(obj, TSmcChip)
end

function TSmcChip.new(SmcChip)
    return TSmcChip_from_obj({SmcChip = SmcChip})
end
---@param obj MLogicFirmware.SmcChip
function TSmcChip:init_from_obj(obj)
    self.SmcChip = obj.SmcChip
end

function TSmcChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmcChip.group)
end

TSmcChip.from_obj = TSmcChip_from_obj

TSmcChip.proto_property = {'SmcChip'}

TSmcChip.default = {{}}

TSmcChip.struct = {{name = 'SmcChip', is_array = true, struct = nil}}

function TSmcChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SmcChip', self.SmcChip, 'uint8', false, errs, need_convert)

    TSmcChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmcChip.proto_property, errs, need_convert)
    return self
end

function TSmcChip:unpack(_)
    return self.SmcChip
end

MLogicFirmware.SmcChip = TSmcChip

---@class MLogicFirmware.Location
---@field Location integer
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj MLogicFirmware.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {0}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'uint32', false, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

MLogicFirmware.Location = TLocation

---@class MLogicFirmware.Version
---@field Version integer
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MLogicFirmware.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {0}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'uint8', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MLogicFirmware.Version = TVersion

---@class MLogicFirmware.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj MLogicFirmware.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

MLogicFirmware.Manufacturer = TManufacturer

---@class MLogicFirmware.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj MLogicFirmware.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MLogicFirmware.SoftwareId = TSoftwareId

---@class MLogicFirmware.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj MLogicFirmware.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MLogicFirmware.Name = TName

---@class MLogicFirmware.UId
---@field UId string
local TUId = {}
TUId.__index = TUId
TUId.group = {}

local function TUId_from_obj(obj)
    return setmetatable(obj, TUId)
end

function TUId.new(UId)
    return TUId_from_obj({UId = UId})
end
---@param obj MLogicFirmware.UId
function TUId:init_from_obj(obj)
    self.UId = obj.UId
end

function TUId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUId.group)
end

TUId.from_obj = TUId_from_obj

TUId.proto_property = {'UId'}

TUId.default = {''}

TUId.struct = {{name = 'UId', is_array = false, struct = nil}}

function TUId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UId', self.UId, 'string', false, errs, need_convert)

    TUId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUId.proto_property, errs, need_convert)
    return self
end

function TUId:unpack(_)
    return self.UId
end

MLogicFirmware.UId = TUId

return MLogicFirmware
