-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MGPU = {}

---@class MGPU.CardPartNumber
---@field CardPartNumber string
local TCardPartNumber = {}
TCardPartNumber.__index = TCardPartNumber
TCardPartNumber.group = {}

local function TCardPartNumber_from_obj(obj)
    return setmetatable(obj, TCardPartNumber)
end

function TCardPartNumber.new(CardPartNumber)
    return TCardPartNumber_from_obj({CardPartNumber = CardPartNumber})
end
---@param obj MGPU.CardPartNumber
function TCardPartNumber:init_from_obj(obj)
    self.CardPartNumber = obj.CardPartNumber
end

function TCardPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardPartNumber.group)
end

TCardPartNumber.from_obj = TCardPartNumber_from_obj

TCardPartNumber.proto_property = {'CardPartNumber'}

TCardPartNumber.default = {''}

TCardPartNumber.struct = {{name = 'CardPartNumber', is_array = false, struct = nil}}

function TCardPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardPartNumber', self.CardPartNumber, 'string', false, errs, need_convert)

    TCardPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardPartNumber.proto_property, errs, need_convert)
    return self
end

function TCardPartNumber:unpack(_)
    return self.CardPartNumber
end

MGPU.CardPartNumber = TCardPartNumber

---@class MGPU.CardFirmwareVersion
---@field CardFirmwareVersion string
local TCardFirmwareVersion = {}
TCardFirmwareVersion.__index = TCardFirmwareVersion
TCardFirmwareVersion.group = {}

local function TCardFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TCardFirmwareVersion)
end

function TCardFirmwareVersion.new(CardFirmwareVersion)
    return TCardFirmwareVersion_from_obj({CardFirmwareVersion = CardFirmwareVersion})
end
---@param obj MGPU.CardFirmwareVersion
function TCardFirmwareVersion:init_from_obj(obj)
    self.CardFirmwareVersion = obj.CardFirmwareVersion
end

function TCardFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardFirmwareVersion.group)
end

TCardFirmwareVersion.from_obj = TCardFirmwareVersion_from_obj

TCardFirmwareVersion.proto_property = {'CardFirmwareVersion'}

TCardFirmwareVersion.default = {''}

TCardFirmwareVersion.struct = {{name = 'CardFirmwareVersion', is_array = false, struct = nil}}

function TCardFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardFirmwareVersion', self.CardFirmwareVersion, 'string', false, errs, need_convert)

    TCardFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TCardFirmwareVersion:unpack(_)
    return self.CardFirmwareVersion
end

MGPU.CardFirmwareVersion = TCardFirmwareVersion

---@class MGPU.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj MGPU.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', false, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

MGPU.SerialNumber = TSerialNumber

---@class MGPU.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj MGPU.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', false, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MGPU.DevFunction = TDevFunction

---@class MGPU.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj MGPU.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', false, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MGPU.DevDevice = TDevDevice

---@class MGPU.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj MGPU.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', false, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MGPU.DevBus = TDevBus

---@class MGPU.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MGPU.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MGPU.RefChip = TRefChip

return MGPU
