-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFwUpdateCfgTable = {}

---@class MFwUpdateCfgTable.Uid
---@field Uid string
local TUid = {}
TUid.__index = TUid
TUid.group = {}

local function TUid_from_obj(obj)
    return setmetatable(obj, TUid)
end

function TUid.new(Uid)
    return TUid_from_obj({Uid = Uid})
end
---@param obj MFwUpdateCfgTable.Uid
function TUid:init_from_obj(obj)
    self.Uid = obj.Uid
end

function TUid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUid.group)
end

TUid.from_obj = TUid_from_obj

TUid.proto_property = {'Uid'}

TUid.default = {''}

TUid.struct = {{name = 'Uid', is_array = false, struct = nil}}

function TUid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Uid', self.Uid, 'string', false, errs, need_convert)

    TUid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUid.proto_property, errs, need_convert)
    return self
end

function TUid:unpack(_)
    return self.Uid
end

MFwUpdateCfgTable.Uid = TUid

---@class MFwUpdateCfgTable.ComponentIdex
---@field ComponentIdex integer
local TComponentIdex = {}
TComponentIdex.__index = TComponentIdex
TComponentIdex.group = {}

local function TComponentIdex_from_obj(obj)
    return setmetatable(obj, TComponentIdex)
end

function TComponentIdex.new(ComponentIdex)
    return TComponentIdex_from_obj({ComponentIdex = ComponentIdex})
end
---@param obj MFwUpdateCfgTable.ComponentIdex
function TComponentIdex:init_from_obj(obj)
    self.ComponentIdex = obj.ComponentIdex
end

function TComponentIdex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentIdex.group)
end

TComponentIdex.from_obj = TComponentIdex_from_obj

TComponentIdex.proto_property = {'ComponentIdex'}

TComponentIdex.default = {0}

TComponentIdex.struct = {{name = 'ComponentIdex', is_array = false, struct = nil}}

function TComponentIdex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ComponentIdex', self.ComponentIdex, 'uint32', false, errs, need_convert)

    TComponentIdex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentIdex.proto_property, errs, need_convert)
    return self
end

function TComponentIdex:unpack(_)
    return self.ComponentIdex
end

MFwUpdateCfgTable.ComponentIdex = TComponentIdex

---@class MFwUpdateCfgTable.ComponentId
---@field ComponentId integer
local TComponentId = {}
TComponentId.__index = TComponentId
TComponentId.group = {}

local function TComponentId_from_obj(obj)
    return setmetatable(obj, TComponentId)
end

function TComponentId.new(ComponentId)
    return TComponentId_from_obj({ComponentId = ComponentId})
end
---@param obj MFwUpdateCfgTable.ComponentId
function TComponentId:init_from_obj(obj)
    self.ComponentId = obj.ComponentId
end

function TComponentId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentId.group)
end

TComponentId.from_obj = TComponentId_from_obj

TComponentId.proto_property = {'ComponentId'}

TComponentId.default = {0}

TComponentId.struct = {{name = 'ComponentId', is_array = false, struct = nil}}

function TComponentId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ComponentId', self.ComponentId, 'uint32', false, errs, need_convert)

    TComponentId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentId.proto_property, errs, need_convert)
    return self
end

function TComponentId:unpack(_)
    return self.ComponentId
end

MFwUpdateCfgTable.ComponentId = TComponentId

---@class MFwUpdateCfgTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MFwUpdateCfgTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MFwUpdateCfgTable.Id = TId

return MFwUpdateCfgTable
