-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftIOTest = {}

---@class MDftIOTest.ActionType
---@field ActionType integer
local TActionType = {}
TActionType.__index = TActionType
TActionType.group = {}

local function TActionType_from_obj(obj)
    return setmetatable(obj, TActionType)
end

function TActionType.new(ActionType)
    return TActionType_from_obj({ActionType = ActionType})
end
---@param obj MDftIOTest.ActionType
function TActionType:init_from_obj(obj)
    self.ActionType = obj.ActionType
end

function TActionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActionType.group)
end

TActionType.from_obj = TActionType_from_obj

TActionType.proto_property = {'ActionType'}

TActionType.default = {0}

TActionType.struct = {{name = 'ActionType', is_array = false, struct = nil}}

function TActionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActionType', self.ActionType, 'uint8', false, errs, need_convert)

    TActionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActionType.proto_property, errs, need_convert)
    return self
end

function TActionType:unpack(_)
    return self.ActionType
end

MDftIOTest.ActionType = TActionType

---@class MDftIOTest.Data
---@field Data integer
local TData = {}
TData.__index = TData
TData.group = {}

local function TData_from_obj(obj)
    return setmetatable(obj, TData)
end

function TData.new(Data)
    return TData_from_obj({Data = Data})
end
---@param obj MDftIOTest.Data
function TData:init_from_obj(obj)
    self.Data = obj.Data
end

function TData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TData.group)
end

TData.from_obj = TData_from_obj

TData.proto_property = {'Data'}

TData.default = {0}

TData.struct = {{name = 'Data', is_array = false, struct = nil}}

function TData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    TData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TData.proto_property, errs, need_convert)
    return self
end

function TData:unpack(_)
    return self.Data
end

MDftIOTest.Data = TData

---@class MDftIOTest.Destination
---@field Destination integer
local TDestination = {}
TDestination.__index = TDestination
TDestination.group = {}

local function TDestination_from_obj(obj)
    return setmetatable(obj, TDestination)
end

function TDestination.new(Destination)
    return TDestination_from_obj({Destination = Destination})
end
---@param obj MDftIOTest.Destination
function TDestination:init_from_obj(obj)
    self.Destination = obj.Destination
end

function TDestination:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestination.group)
end

TDestination.from_obj = TDestination_from_obj

TDestination.proto_property = {'Destination'}

TDestination.default = {0}

TDestination.struct = {{name = 'Destination', is_array = false, struct = nil}}

function TDestination:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Destination', self.Destination, 'uint8', false, errs, need_convert)

    TDestination:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestination.proto_property, errs, need_convert)
    return self
end

function TDestination:unpack(_)
    return self.Destination
end

MDftIOTest.Destination = TDestination

return MDftIOTest
