-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCpldReset = {}

---@class MCpldReset.Bcu
---@field Bcu integer
local TBcu = {}
TBcu.__index = TBcu
TBcu.group = {}

local function TBcu_from_obj(obj)
    return setmetatable(obj, TBcu)
end

function TBcu.new(Bcu)
    return TBcu_from_obj({Bcu = Bcu})
end
---@param obj MCpldReset.Bcu
function TBcu:init_from_obj(obj)
    self.Bcu = obj.Bcu
end

function TBcu:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBcu.group)
end

TBcu.from_obj = TBcu_from_obj

TBcu.proto_property = {'Bcu'}

TBcu.default = {0}

TBcu.struct = {{name = 'Bcu', is_array = false, struct = nil}}

function TBcu:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bcu', self.Bcu, 'uint8', false, errs, need_convert)

    TBcu:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBcu.proto_property, errs, need_convert)
    return self
end

function TBcu:unpack(_)
    return self.Bcu
end

MCpldReset.Bcu = TBcu

return MCpldReset
