-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MBoardSlotConfig = {}

---@class MBoardSlotConfig.SlotConfigs
---@field SlotConfigs def_types.SlotConfig[]
local TSlotConfigs = {}
TSlotConfigs.__index = TSlotConfigs
TSlotConfigs.group = {}

local function TSlotConfigs_from_obj(obj)
    obj.SlotConfigs = utils.from_obj(def_types.SlotConfig, obj.SlotConfigs, true)
    return setmetatable(obj, TSlotConfigs)
end

function TSlotConfigs.new(SlotConfigs)
    return TSlotConfigs_from_obj({SlotConfigs = SlotConfigs})
end
---@param obj MBoardSlotConfig.SlotConfigs
function TSlotConfigs:init_from_obj(obj)
    self.SlotConfigs = obj.SlotConfigs
end

function TSlotConfigs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotConfigs.group)
end

TSlotConfigs.from_obj = TSlotConfigs_from_obj

TSlotConfigs.proto_property = {'SlotConfigs'}

TSlotConfigs.default = {{}}

TSlotConfigs.struct = {{name = 'SlotConfigs', is_array = true, struct = def_types.SlotConfig.struct}}

function TSlotConfigs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SlotConfigs) do
        def_types.SlotConfig.new(v.SelfSlot, v.ChildSlotType, v.ChildSlotIndex, v.ChildSlotNumber, v.ChildSlotSilkText,
            v.ChildSlotStartSlot):validate(prefix, errs, need_convert)
    end

    TSlotConfigs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotConfigs.proto_property, errs, need_convert)
    return self
end

function TSlotConfigs:unpack(raw)
    return utils.unpack(raw, self.SlotConfigs, true)
end

MBoardSlotConfig.SlotConfigs = TSlotConfigs

---@class MBoardSlotConfig.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MBoardSlotConfig.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MBoardSlotConfig.UID = TUID

return MBoardSlotConfig
