# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
import os
from conanbase import ConanBase


class AppConan(ConanBase):
    def check_path_is_existed(self, path):
        if os.path.exists(path):
            return True
        return False

    def build(self):
        if self.options.qemu:
            self.__sed_unit_lua()
        super().build()

    def package(self):
        super().package()
        self.copy("permissions.ini", src="dist/")

    def package_info(self):
        pass

    def __sed_unit_lua(self):
        des = "src/lualib/unit_manager/class/unit/unit.lua"
        if not self.check_path_is_existed(des):
            return
        self.run("sed -i 's/skynet.sleep(100)/skynet.sleep(1000)/g' {}".format(des))
        self.run("sed -i 's/skynet.sleep(200)/skynet.sleep(2000)/g' {}".format(des))