-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local common = require 'common'
local lu = require 'luaunit'
function Test_Fru_Data:test_validate_byte()
    lu.assertIsTrue(common.validate_byte(1, 0, ''))
    lu.assertIsTrue(common.validate_byte(2, 0, '\x00'))
    lu.assertIsTrue(common.validate_byte(6, 2, 'abc123'))
    lu.assertIsTrue(common.validate_byte(3, 1, 'TEST (2280)'))
    lu.assertIsTrue(common.validate_byte(3, 1, 'TE\x0aST (2280)\x0d'))
    lu.assertIsFalse(common.validate_byte(3, 1, 'Tais\x0ahan\x01 (2280)\x0d'))
    lu.assertIsFalse(common.validate_byte(3, 1, '嗯嗯'))
    lu.assertIsFalse(common.validate_byte(3, 1, '12（3'))
end

function Test_Fru_Data:test_copy_str()
    lu.assertIsTrue(common.copy_str('a', 0) == '')
    lu.assertIsTrue(common.copy_str('a', 1) == 'a')
    lu.assertIsTrue(common.copy_str('a', 2) == 'aa')
    lu.assertIsTrue(common.copy_str('a', 3) == 'aaa')
    lu.assertIsTrue(common.copy_str('ab', 6) == 'abababababab')
    lu.assertIsTrue(common.copy_str('abc', 5) == 'abcabcabcabcabc')
end

function Test_Fru_Data:test_string_to_char()
    lu.assertIsTrue(common.string_to_char('010101') == '\x01\x01\x01')
    lu.assertIsTrue(common.string_to_char('303132') == '012')
    lu.assertIsTrue(common.string_to_char('2d3f4a') == '\x2d\x3f\x4a')
    -- 异常场景
    lu.assertIsTrue(common.string_to_char('2d3f') == '')
    lu.assertIsTrue(common.string_to_char('2d3t3f') == '')
end
