-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Log = {}

local cjson = require "cjson"

local log_file = "test/integration/.test_temp_data/data/mockdata/mock_log"

LOG_ERROR = 0
LOG_DEBUG = 1

local default_log_level = LOG_ERROR

function Log:write_file(data)
    local file = io.open(log_file, "a+")
    if file == nil then
        return
    end
    file:write(data)
    file:close()
end

function Log:print(level, fmt, ...)
    local cur_time = os.date("%c")
    local json = cjson.encode(string.format(fmt, ...))
    local info = debug.getinfo(2)
    local chip_name = string.match(info.short_src, "[%a]+%.lua") or "unknown"
    local line_num = info.currentline
    local str = "["..cur_time.."]".."["..FileName.."]".."("..chip_name..")".."("..line_num..")"..json.."\n"
    if default_log_level >= level then
        self:write_file(str)
    end
    if default_log_level == LOG_DEBUG then
        print(str)
    end
end

return Log