-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local common = require 'common'
local sd_bus = require 'sd_bus'
local mdb = require 'mc.mdb'

local FWINFO_INTERFACE = 'bmc.kepler.UpdateService.FirmwareInfo'
local FWINFO_PATH = '/bmc/kepler/UpdateService/FirmwareInventory/ActiveBMC'

local prop_intf = mdb.register_interface('bmc.kepler.Object.Properties', {
    ClassName = { 's', nil, true, nil, false },
    ObjectName = { 's', nil, true, nil, false },
    ObjectIdentifier = { '(ysss)', nil, true, nil, false }
}, {}, {})

local fwinfo_interface = mdb.register_interface(FWINFO_INTERFACE,
    { Version = { 's', nil, false, '5.0.0.1', false } }, {}, {})
local sdr = mdb.register_object(FWINFO_PATH,
    { { name = 'FirmwareInfo', interface = fwinfo_interface }, { name = 'ObjectProperties', interface = prop_intf } })
function sdr:ctor()
    self.path = FWINFO_PATH
end

local stub = {}

function stub:register_firmware_mgmt()
    self.bus = sd_bus.open_user(true)
    self.bus:request_name('bmc.kepler.firmware_mgmt')
    -- regist FirmwareInfo
    self.obj = sdr.FirmwareInfo.new()
    self.obj:register(self.bus)

    self.prop_obj = sdr.ObjectProperties.new('1')
    self.prop_obj.ObjectIdentifier = { 0, '', '', '' }
    self.prop_obj:register(self.bus)
end

skynet.start(function()
    stub:register_firmware_mgmt()
end)

