-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local ipmi_gen = require 'frudata.ipmi.ipmi'
local fru_ipmi = require 'fru_ipmi'

local ipmi = {}
ipmi.__index = ipmi

function ipmi.new(non_standard)
    return setmetatable({
        non_standard = non_standard
    }, ipmi)
end

local function register_frudata_ipmi(func, non_standard)
    func(ipmi_gen.ReadElabelData, function(...)
        return fru_ipmi.read_elabel_data(...)
    end)
    func(ipmi_gen.ClearElabelData, function(...)
        return fru_ipmi.clear_elabel_data(non_standard, ...)
    end)
    func(ipmi_gen.WriteElabelData, function(...)
        return fru_ipmi.write_elabe_data(non_standard, ...)
    end)
    func(ipmi_gen.UpdateElabelData, function(...)
        return fru_ipmi.update_elabel_data(non_standard, ...)
    end)
    func(ipmi_gen.ReadFruData, function(...)
        return fru_ipmi.read_fru_data(...)
    end)
    func(ipmi_gen.GetPicmgProperties, function(...)
        return fru_ipmi.get_picmg_properties(...)
    end)
    func(ipmi_gen.GetAddressInfo, function(...)
        return fru_ipmi.ipmi_get_addr_info(...)
    end)
    func(ipmi_gen.ComputePowerProperties, function(...)
        return fru_ipmi.compute_power(...)
    end)
    func(ipmi_gen.GetFruidInfo, function(...)
        return fru_ipmi.get_fruid_info(...)
    end)
    func(ipmi_gen.IpmiWriteFrudata, function(...)
        return fru_ipmi.ipmi_write_frudata(...)
    end)
    func(ipmi_gen.GetComponentInfo, function(...)
        return fru_ipmi.get_component_info(...)
    end)
    func(ipmi_gen.IpmiDftCustom, function(...)
        return fru_ipmi.ipmi_dft_custom(...)
    end)
    func(ipmi_gen.IpmiGetDftCustom, function(...)
        return fru_ipmi.ipmi_get_dft_custom(...)
    end)
end

local function register_fru_ipmi(func)
    func(ipmi_gen.FruControlCapabilities, function(...)
        return fru_ipmi.fru_control_capabilities(...)
    end)
    func(ipmi_gen.GetFruInventory, function(...)
        return fru_ipmi.get_fru_inventory(...)
    end)
    func(ipmi_gen.GetFruidFromUid, function(...)
        return fru_ipmi.get_fruid_from_uid(...)
    end)
    func(ipmi_gen.GetComponentPositionInfo, function(...)
        return fru_ipmi.get_component_position_info(...)
    end)
end

local function register_get_device_info(func)
    func(ipmi_gen.GetDevicePresence, function(...)
        return fru_ipmi.get_device_presence(...)
    end)
    func(ipmi_gen.GetDeviceHealth, function(...)
        return fru_ipmi.get_device_health(...)
    end)
    func(ipmi_gen.GetDeviceBoardID, function(...)
        return fru_ipmi.get_device_boardid(...)
    end)
    func(ipmi_gen.GetDeviceLocation, function(...)
        return fru_ipmi.get_device_location(...)
    end)
    func(ipmi_gen.GetDeviceFunction, function(...)
        return fru_ipmi.get_device_function(...)
    end)
    func(ipmi_gen.GetDeviceName, function(...)
        return fru_ipmi.get_device_name(...)
    end)
    func(ipmi_gen.GetDeviceGroupID, function(...)
        return fru_ipmi.get_device_groupid(...)
    end)
    func(ipmi_gen.GetDeviceFruid, function(...)
        return fru_ipmi.get_device_fruid(...)
    end)
    func(ipmi_gen.GetDeviceUniqueId, function(...)
        return fru_ipmi.get_device_uniqueid(...)
    end)
    func(ipmi_gen.GetGeneralDeviceManufacture, function(...)
        return fru_ipmi.ipmi_get_general_device_manufacture(...)
    end)
end

function ipmi:register_ipmi(func)
    register_frudata_ipmi(func, self.non_standard)
    register_fru_ipmi(func)
    register_get_device_info(func)
end

return ipmi
