-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local log = require 'mc.logging'
local manage = require 'frudata_object.manage'

local frudata_object = {}

frudata_object.__index = frudata_object

function frudata_object:new(fruinfo_manage, obj)
    return setmetatable({
        fruinfo_manage = fruinfo_manage,
        obj = obj
    }, frudata_object)
end

function frudata_object:init()
    manage:init(self.obj)
end

function frudata_object:write_system_area_to_eep(fru_id)
    log:error('StorageType is non standrad, not have system area')
end

function frudata_object:write_fru_area(fru_id, data)
    manage:write_fru_area_to_eep(fru_id, data, self.obj, self.fruinfo_manage)
end

function frudata_object:update_sys_data_to_dbus(fru_id)
    manage:update_sys_data_to_dbus(fru_id, self.obj)
end

function frudata_object:update_fru_data_to_dbus(fru_id)
    manage:update_fru_data_to_dbus(fru_id, self.obj)
end

return frudata_object
