-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NodeLocation = {}

---@class NodeLocation.LocationType
---@field LocationType string
local TLocationType = {}
TLocationType.__index = TLocationType
TLocationType.group = {}

local function TLocationType_from_obj(obj)
    return setmetatable(obj, TLocationType)
end

function TLocationType.new(LocationType)
    return TLocationType_from_obj({LocationType = LocationType or [=[Slot]=]})
end
---@param obj NodeLocation.LocationType
function TLocationType:init_from_obj(obj)
    self.LocationType = obj.LocationType or [=[Slot]=]
end

function TLocationType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationType.group)
end

TLocationType.from_obj = TLocationType_from_obj

TLocationType.proto_property = {'LocationType'}

TLocationType.default = {''}

TLocationType.struct = {{name = 'LocationType', is_array = false, struct = nil}}

function TLocationType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationType', self.LocationType, 'string', true, errs, need_convert)

    TLocationType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationType.proto_property, errs, need_convert)
    return self
end

function TLocationType:unpack(_)
    return self.LocationType
end

NodeLocation.LocationType = TLocationType

---@class NodeLocation.LocationId
---@field LocationId integer
local TLocationId = {}
TLocationId.__index = TLocationId
TLocationId.group = {}

local function TLocationId_from_obj(obj)
    return setmetatable(obj, TLocationId)
end

function TLocationId.new(LocationId)
    return TLocationId_from_obj({LocationId = LocationId or 0})
end
---@param obj NodeLocation.LocationId
function TLocationId:init_from_obj(obj)
    self.LocationId = obj.LocationId or 0
end

function TLocationId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationId.group)
end

TLocationId.from_obj = TLocationId_from_obj

TLocationId.proto_property = {'LocationId'}

TLocationId.default = {0}

TLocationId.struct = {{name = 'LocationId', is_array = false, struct = nil}}

function TLocationId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationId', self.LocationId, 'uint8', false, errs, need_convert)

    TLocationId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationId.proto_property, errs, need_convert)
    return self
end

function TLocationId:unpack(_)
    return self.LocationId
end

NodeLocation.LocationId = TLocationId

NodeLocation.interface = mdb.register_interface('bmc.kepler.Managers.NodeLocation', {
    LocationId = {'y', nil, false, 0, false},
    LocationType = {'s', {}, true, 'Slot', false}
}, {}, {})

return NodeLocation
