-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Frus = {}

---@class Frus.FruRemovedSignature
---@field FruId integer
---@field FruName string
---@field Path string
local TFruRemovedSignature = {}
TFruRemovedSignature.__index = TFruRemovedSignature
TFruRemovedSignature.group = {}

local function TFruRemovedSignature_from_obj(obj)
    return setmetatable(obj, TFruRemovedSignature)
end

function TFruRemovedSignature.new(FruId, FruName, Path)
    return TFruRemovedSignature_from_obj({FruId = FruId, FruName = FruName, Path = Path})
end
---@param obj Frus.FruRemovedSignature
function TFruRemovedSignature:init_from_obj(obj)
    self.FruId = obj.FruId
    self.FruName = obj.FruName
    self.Path = obj.Path
end

function TFruRemovedSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruRemovedSignature.group)
end

TFruRemovedSignature.from_obj = TFruRemovedSignature_from_obj

TFruRemovedSignature.proto_property = {'FruId', 'FruName', 'Path'}

TFruRemovedSignature.default = {0, '', ''}

TFruRemovedSignature.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'FruName', is_array = false, struct = nil},
    {name = 'Path', is_array = false, struct = nil}
}

function TFruRemovedSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruName', self.FruName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TFruRemovedSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruRemovedSignature.proto_property, errs, need_convert)
    return self
end

function TFruRemovedSignature:unpack(_)
    return self.FruId, self.FruName, self.Path
end

Frus.FruRemovedSignature = TFruRemovedSignature

---@class Frus.FruAddedSignature
---@field FruId integer
---@field FruName string
---@field Path string
local TFruAddedSignature = {}
TFruAddedSignature.__index = TFruAddedSignature
TFruAddedSignature.group = {}

local function TFruAddedSignature_from_obj(obj)
    return setmetatable(obj, TFruAddedSignature)
end

function TFruAddedSignature.new(FruId, FruName, Path)
    return TFruAddedSignature_from_obj({FruId = FruId, FruName = FruName, Path = Path})
end
---@param obj Frus.FruAddedSignature
function TFruAddedSignature:init_from_obj(obj)
    self.FruId = obj.FruId
    self.FruName = obj.FruName
    self.Path = obj.Path
end

function TFruAddedSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruAddedSignature.group)
end

TFruAddedSignature.from_obj = TFruAddedSignature_from_obj

TFruAddedSignature.proto_property = {'FruId', 'FruName', 'Path'}

TFruAddedSignature.default = {0, '', ''}

TFruAddedSignature.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'FruName', is_array = false, struct = nil},
    {name = 'Path', is_array = false, struct = nil}
}

function TFruAddedSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruName', self.FruName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TFruAddedSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruAddedSignature.proto_property, errs, need_convert)
    return self
end

function TFruAddedSignature:unpack(_)
    return self.FruId, self.FruName, self.Path
end

Frus.FruAddedSignature = TFruAddedSignature

Frus.interface = mdb.register_interface('bmc.kepler.Systems.Frus', {}, {},
    {FruAdded = 'a{ss}yss', FruRemoved = 'a{ss}yss'})

return Frus
