-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Components = {}

---@class Components.GetComponentTypesReq
local TGetComponentTypesReq = {}
TGetComponentTypesReq.__index = TGetComponentTypesReq
TGetComponentTypesReq.group = {}

local function TGetComponentTypesReq_from_obj(obj)
    return setmetatable(obj, TGetComponentTypesReq)
end

function TGetComponentTypesReq.new()
    return TGetComponentTypesReq_from_obj({})
end
---@param obj Components.GetComponentTypesReq
function TGetComponentTypesReq:init_from_obj(obj)

end

function TGetComponentTypesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentTypesReq.group)
end

TGetComponentTypesReq.from_obj = TGetComponentTypesReq_from_obj

TGetComponentTypesReq.proto_property = {}

TGetComponentTypesReq.default = {}

TGetComponentTypesReq.struct = {}

function TGetComponentTypesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetComponentTypesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentTypesReq.proto_property, errs, need_convert)
    return self
end

function TGetComponentTypesReq:unpack(_)
end

Components.GetComponentTypesReq = TGetComponentTypesReq

---@class Components.ComponentTypes
---@field ComponentType integer
---@field ComponentName string
local TComponentTypes = {}
TComponentTypes.__index = TComponentTypes
TComponentTypes.group = {}

local function TComponentTypes_from_obj(obj)
    return setmetatable(obj, TComponentTypes)
end

function TComponentTypes.new(ComponentType, ComponentName)
    return TComponentTypes_from_obj({ComponentType = ComponentType, ComponentName = ComponentName})
end
---@param obj Components.ComponentTypes
function TComponentTypes:init_from_obj(obj)
    self.ComponentType = obj.ComponentType
    self.ComponentName = obj.ComponentName
end

function TComponentTypes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentTypes.group)
end

TComponentTypes.from_obj = TComponentTypes_from_obj

TComponentTypes.proto_property = {'ComponentType', 'ComponentName'}

TComponentTypes.default = {0, ''}

TComponentTypes.struct = {
    {name = 'ComponentType', is_array = false, struct = nil}, {name = 'ComponentName', is_array = false, struct = nil}
}

function TComponentTypes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentType', self.ComponentType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ComponentName', self.ComponentName, 'string', false, errs, need_convert)

    TComponentTypes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentTypes.proto_property, errs, need_convert)
    return self
end

function TComponentTypes:unpack(_)
    return self.ComponentType, self.ComponentName
end

Components.ComponentTypes = TComponentTypes

---@class Components.GetComponentTypesRsp
---@field ComponentTypes Components.ComponentTypes[]
local TGetComponentTypesRsp = {}
TGetComponentTypesRsp.__index = TGetComponentTypesRsp
TGetComponentTypesRsp.group = {}

local function TGetComponentTypesRsp_from_obj(obj)
    obj.ComponentTypes = utils.from_obj(Components.ComponentTypes, obj.ComponentTypes, true)
    return setmetatable(obj, TGetComponentTypesRsp)
end

function TGetComponentTypesRsp.new(ComponentTypes)
    return TGetComponentTypesRsp_from_obj({ComponentTypes = ComponentTypes})
end
---@param obj Components.GetComponentTypesRsp
function TGetComponentTypesRsp:init_from_obj(obj)
    self.ComponentTypes = obj.ComponentTypes
end

function TGetComponentTypesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentTypesRsp.group)
end

TGetComponentTypesRsp.from_obj = TGetComponentTypesRsp_from_obj

TGetComponentTypesRsp.proto_property = {'ComponentTypes'}

TGetComponentTypesRsp.default = {{}}

TGetComponentTypesRsp.struct = {{name = 'ComponentTypes', is_array = true, struct = Components.ComponentTypes.struct}}

function TGetComponentTypesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ComponentTypes) do
        Components.ComponentTypes.new(v.ComponentType, v.ComponentName):validate(prefix, errs, need_convert)
    end

    TGetComponentTypesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentTypesRsp.proto_property, errs, need_convert)
    return self
end

function TGetComponentTypesRsp:unpack(raw)
    return utils.unpack(raw, self.ComponentTypes, true)
end

Components.GetComponentTypesRsp = TGetComponentTypesRsp

Components.interface = mdb.register_interface('bmc.kepler.Systems.Components', {}, {
    GetComponentTypes = {'a{ss}', 'a(ys)', TGetComponentTypesReq, TGetComponentTypesRsp}
}, {})

return Components
