-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Component = {}

---@class Component.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj Component.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

Component.NodeId = TNodeId

---@class Component.ReplaceFlag
---@field ReplaceFlag integer
local TReplaceFlag = {}
TReplaceFlag.__index = TReplaceFlag
TReplaceFlag.group = {}

local function TReplaceFlag_from_obj(obj)
    return setmetatable(obj, TReplaceFlag)
end

function TReplaceFlag.new(ReplaceFlag)
    return TReplaceFlag_from_obj({ReplaceFlag = ReplaceFlag})
end
---@param obj Component.ReplaceFlag
function TReplaceFlag:init_from_obj(obj)
    self.ReplaceFlag = obj.ReplaceFlag
end

function TReplaceFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReplaceFlag.group)
end

TReplaceFlag.from_obj = TReplaceFlag_from_obj

TReplaceFlag.proto_property = {'ReplaceFlag'}

TReplaceFlag.default = {0}

TReplaceFlag.struct = {{name = 'ReplaceFlag', is_array = false, struct = nil}}

function TReplaceFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReplaceFlag', self.ReplaceFlag, 'uint8', true, errs, need_convert)

    TReplaceFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReplaceFlag.proto_property, errs, need_convert)
    return self
end

function TReplaceFlag:unpack(_)
    return self.ReplaceFlag
end

Component.ReplaceFlag = TReplaceFlag

---@class Component.PreviousSN
---@field PreviousSN string
local TPreviousSN = {}
TPreviousSN.__index = TPreviousSN
TPreviousSN.group = {}

local function TPreviousSN_from_obj(obj)
    return setmetatable(obj, TPreviousSN)
end

function TPreviousSN.new(PreviousSN)
    return TPreviousSN_from_obj({PreviousSN = PreviousSN})
end
---@param obj Component.PreviousSN
function TPreviousSN:init_from_obj(obj)
    self.PreviousSN = obj.PreviousSN
end

function TPreviousSN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreviousSN.group)
end

TPreviousSN.from_obj = TPreviousSN_from_obj

TPreviousSN.proto_property = {'PreviousSN'}

TPreviousSN.default = {''}

TPreviousSN.struct = {{name = 'PreviousSN', is_array = false, struct = nil}}

function TPreviousSN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreviousSN', self.PreviousSN, 'string', true, errs, need_convert)

    TPreviousSN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreviousSN.proto_property, errs, need_convert)
    return self
end

function TPreviousSN:unpack(_)
    return self.PreviousSN
end

Component.PreviousSN = TPreviousSN

---@class Component.Function
---@field Function string
local TFunction = {}
TFunction.__index = TFunction
TFunction.group = {}

local function TFunction_from_obj(obj)
    return setmetatable(obj, TFunction)
end

function TFunction.new(Function)
    return TFunction_from_obj({Function = Function})
end
---@param obj Component.Function
function TFunction:init_from_obj(obj)
    self.Function = obj.Function
end

function TFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunction.group)
end

TFunction.from_obj = TFunction_from_obj

TFunction.proto_property = {'Function'}

TFunction.default = {''}

TFunction.struct = {{name = 'Function', is_array = false, struct = nil}}

function TFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Function', self.Function, 'string', true, errs, need_convert)

    TFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunction.proto_property, errs, need_convert)
    return self
end

function TFunction:unpack(_)
    return self.Function
end

Component.Function = TFunction

---@class Component.SegmentId
---@field SegmentId integer
local TSegmentId = {}
TSegmentId.__index = TSegmentId
TSegmentId.group = {}

local function TSegmentId_from_obj(obj)
    return setmetatable(obj, TSegmentId)
end

function TSegmentId.new(SegmentId)
    return TSegmentId_from_obj({SegmentId = SegmentId})
end
---@param obj Component.SegmentId
function TSegmentId:init_from_obj(obj)
    self.SegmentId = obj.SegmentId
end

function TSegmentId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegmentId.group)
end

TSegmentId.from_obj = TSegmentId_from_obj

TSegmentId.proto_property = {'SegmentId'}

TSegmentId.default = {0}

TSegmentId.struct = {{name = 'SegmentId', is_array = false, struct = nil}}

function TSegmentId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SegmentId', self.SegmentId, 'uint8', true, errs, need_convert)

    TSegmentId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegmentId.proto_property, errs, need_convert)
    return self
end

function TSegmentId:unpack(_)
    return self.SegmentId
end

Component.SegmentId = TSegmentId

---@class Component.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Component.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Component.PartNumber = TPartNumber

---@class Component.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Component.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Component.SerialNumber = TSerialNumber

---@class Component.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj Component.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', true, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

Component.Location = TLocation

---@class Component.GroupId
---@field GroupId integer
local TGroupId = {}
TGroupId.__index = TGroupId
TGroupId.group = {}

local function TGroupId_from_obj(obj)
    return setmetatable(obj, TGroupId)
end

function TGroupId.new(GroupId)
    return TGroupId_from_obj({GroupId = GroupId or 1})
end
---@param obj Component.GroupId
function TGroupId:init_from_obj(obj)
    self.GroupId = obj.GroupId or 1
end

function TGroupId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupId.group)
end

TGroupId.from_obj = TGroupId_from_obj

TGroupId.proto_property = {'GroupId'}

TGroupId.default = {0}

TGroupId.struct = {{name = 'GroupId', is_array = false, struct = nil}}

function TGroupId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', true, errs, need_convert)

    TGroupId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupId.proto_property, errs, need_convert)
    return self
end

function TGroupId:unpack(_)
    return self.GroupId
end

Component.GroupId = TGroupId

---@class Component.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Component.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Component.Manufacturer = TManufacturer

---@class Component.UniqueId
---@field UniqueId string
local TUniqueId = {}
TUniqueId.__index = TUniqueId
TUniqueId.group = {}

local function TUniqueId_from_obj(obj)
    return setmetatable(obj, TUniqueId)
end

function TUniqueId.new(UniqueId)
    return TUniqueId_from_obj({UniqueId = UniqueId})
end
---@param obj Component.UniqueId
function TUniqueId:init_from_obj(obj)
    self.UniqueId = obj.UniqueId
end

function TUniqueId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUniqueId.group)
end

TUniqueId.from_obj = TUniqueId_from_obj

TUniqueId.proto_property = {'UniqueId'}

TUniqueId.default = {''}

TUniqueId.struct = {{name = 'UniqueId', is_array = false, struct = nil}}

function TUniqueId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UniqueId', self.UniqueId, 'string', true, errs, need_convert)

    TUniqueId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUniqueId.proto_property, errs, need_convert)
    return self
end

function TUniqueId:unpack(_)
    return self.UniqueId
end

Component.UniqueId = TUniqueId

---@class Component.BoardId
---@field BoardId integer
local TBoardId = {}
TBoardId.__index = TBoardId
TBoardId.group = {}

local function TBoardId_from_obj(obj)
    return setmetatable(obj, TBoardId)
end

function TBoardId.new(BoardId)
    return TBoardId_from_obj({BoardId = BoardId})
end
---@param obj Component.BoardId
function TBoardId:init_from_obj(obj)
    self.BoardId = obj.BoardId
end

function TBoardId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardId.group)
end

TBoardId.from_obj = TBoardId_from_obj

TBoardId.proto_property = {'BoardId'}

TBoardId.default = {0}

TBoardId.struct = {{name = 'BoardId', is_array = false, struct = nil}}

function TBoardId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardId', self.BoardId, 'uint16', true, errs, need_convert)

    TBoardId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardId.proto_property, errs, need_convert)
    return self
end

function TBoardId:unpack(_)
    return self.BoardId
end

Component.BoardId = TBoardId

---@class Component.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj Component.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

Component.PowerState = TPowerState

---@class Component.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj Component.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', false, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Component.Health = THealth

---@class Component.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Component.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Component.Presence = TPresence

---@class Component.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Component.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Component.Name = TName

---@class Component.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj Component.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

Component.Type = TType

---@class Component.Instance
---@field Instance integer
local TInstance = {}
TInstance.__index = TInstance
TInstance.group = {}

local function TInstance_from_obj(obj)
    return setmetatable(obj, TInstance)
end

function TInstance.new(Instance)
    return TInstance_from_obj({Instance = Instance})
end
---@param obj Component.Instance
function TInstance:init_from_obj(obj)
    self.Instance = obj.Instance
end

function TInstance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstance.group)
end

TInstance.from_obj = TInstance_from_obj

TInstance.proto_property = {'Instance'}

TInstance.default = {0}

TInstance.struct = {{name = 'Instance', is_array = false, struct = nil}}

function TInstance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Instance', self.Instance, 'uint8', true, errs, need_convert)

    TInstance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstance.proto_property, errs, need_convert)
    return self
end

function TInstance:unpack(_)
    return self.Instance
end

Component.Instance = TInstance

---@class Component.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj Component.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', true, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

Component.FruId = TFruId

---@class Component.UpdateHealthRsp
local TUpdateHealthRsp = {}
TUpdateHealthRsp.__index = TUpdateHealthRsp
TUpdateHealthRsp.group = {}

local function TUpdateHealthRsp_from_obj(obj)
    return setmetatable(obj, TUpdateHealthRsp)
end

function TUpdateHealthRsp.new()
    return TUpdateHealthRsp_from_obj({})
end
---@param obj Component.UpdateHealthRsp
function TUpdateHealthRsp:init_from_obj(obj)

end

function TUpdateHealthRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateHealthRsp.group)
end

TUpdateHealthRsp.from_obj = TUpdateHealthRsp_from_obj

TUpdateHealthRsp.proto_property = {}

TUpdateHealthRsp.default = {}

TUpdateHealthRsp.struct = {}

function TUpdateHealthRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUpdateHealthRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateHealthRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateHealthRsp:unpack(_)
end

Component.UpdateHealthRsp = TUpdateHealthRsp

---@class Component.UpdateHealthReq
---@field Health integer
local TUpdateHealthReq = {}
TUpdateHealthReq.__index = TUpdateHealthReq
TUpdateHealthReq.group = {}

local function TUpdateHealthReq_from_obj(obj)
    return setmetatable(obj, TUpdateHealthReq)
end

function TUpdateHealthReq.new(Health)
    return TUpdateHealthReq_from_obj({Health = Health})
end
---@param obj Component.UpdateHealthReq
function TUpdateHealthReq:init_from_obj(obj)
    self.Health = obj.Health
end

function TUpdateHealthReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateHealthReq.group)
end

TUpdateHealthReq.from_obj = TUpdateHealthReq_from_obj

TUpdateHealthReq.proto_property = {'Health'}

TUpdateHealthReq.default = {0}

TUpdateHealthReq.struct = {{name = 'Health', is_array = false, struct = nil}}

function TUpdateHealthReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', false, errs, need_convert)

    TUpdateHealthReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateHealthReq.proto_property, errs, need_convert)
    return self
end

function TUpdateHealthReq:unpack(_)
    return self.Health
end

Component.UpdateHealthReq = TUpdateHealthReq

Component.interface = mdb.register_interface('bmc.kepler.Systems.Component', {
    FruId = {'y', {}, true, nil, false},
    Instance = {'y', nil, true, nil, false},
    Type = {'y', {}, true, nil, false},
    Name = {'s', nil, false, nil, false},
    Presence = {'y', nil, true, nil, false},
    Health = {'y', nil, false, nil, false},
    PowerState = {'y', {}, true, nil, false},
    BoardId = {'q', {}, true, nil, false},
    UniqueId = {'s', {}, true, nil, false},
    Manufacturer = {'s', {}, true, nil, false},
    GroupId = {'y', {}, true, 1, false},
    Location = {'s', {}, true, nil, false},
    SerialNumber = {'s', nil, true, nil, false},
    PartNumber = {'s', {}, true, nil, false},
    SegmentId = {'y', {}, true, nil, false},
    Function = {'s', {}, true, nil, false},
    PreviousSN = {'s', nil, true, nil, false},
    ReplaceFlag = {'y', nil, true, nil, false},
    NodeId = {'s', {}, true, nil, false}
}, {UpdateHealth = {'a{ss}y', '', TUpdateHealthReq, TUpdateHealthRsp}}, {})

return Component
