--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'frudata.ipmi.ipmi_message'

local CT = enums.ChannelType

local FrudataIpmiCmds = {}

FrudataIpmiCmds.ClearElabelData = {
    name = 'ClearElabelData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[03]=],
    decode = [=[<<0x03:1/unit:8, FruId:1/unit:8, Option:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EraseProgress:1/unit:8>]=] .. [=[>]=],
    req = msg.ClearElabelDataReq,
    rsp = msg.ClearElabelDataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.WriteElabelData = {
    name = 'WriteElabelData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[04]=],
    decode = [=[<<0x04:1/unit:8, FruId:1/unit:8, Area:1/unit:8, Fi]=] ..
        [=[eld:1/unit:8, Offset:1/unit:8, Len:1/unit:8, Datas]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.WriteElabelDataReq,
    rsp = msg.WriteElabelDataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.ReadElabelData = {
    name = 'ReadElabelData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[05]=],
    decode = [=[<<0x05:1/unit:8, FruId:1/unit:8, Area:1/unit:8, Fi]=] ..
        [=[eld:1/unit:8, Offset:1/unit:8, Len:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndFlag:1/unit:8, RespD]=] .. [=[atas/string>>]=],
    req = msg.ReadElabelDataReq,
    rsp = msg.ReadElabelDataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.UpdateElabelData = {
    name = 'UpdateElabelData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[06]=],
    decode = [=[<<0x06:1/unit:8, FruId:1/unit:8, Option:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, UpdateProgress/string>>]=],
    req = msg.UpdateElabelDataReq,
    rsp = msg.UpdateElabelDataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.GetPicmgProperties = {
    name = 'GetPicmgProperties',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x00,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<PicmgIdentifier:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgId:1/unit:8, Picmg]=] ..
        [=[ExtensionVersion:1/unit:8, FruCount:1/unit:8, FruD]=] .. [=[eviceId:1/unit:8>>]=],
    req = msg.GetPicmgPropertiesReq,
    rsp = msg.GetPicmgPropertiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetAddressInfo = {
    name = 'GetAddressInfo',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x01,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Identifier:1/unit:8, Ha]=] ..
        [=[rdwareAddr:1/unit:8, IpmbAddr:1/unit:8, Reserved:1]=] ..
        [=[/unit:8, Id:1/unit:8, SiteNumber:1/unit:8, SiteTyp]=] .. [=[e:1/unit:8>>]=],
    req = msg.GetAddressInfoReq,
    rsp = msg.GetAddressInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.ComputePowerProperties = {
    name = 'ComputePowerProperties',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x10,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Identifier:1/unit:8, Sl]=] .. [=[ot:1/unit:8, Location:1/unit:8>>]=],
    req = msg.ComputePowerPropertiesReq,
    rsp = msg.ComputePowerPropertiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetFruidInfo = {
    name = 'GetFruidInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3B,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3B:1/unit:8, 0x00:1/un]=] ..
        [=[it:8, DeviceType:1/unit:8, GroupId:1/unit:8, Devic]=] ..
        [=[eNumber:1/unit:8, ReservedH:1/unit:8, ReadOffset:1]=] .. [=[/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndofList:1/unit:8, Data/string>>]=],
    req = msg.GetFruidInfoReq,
    rsp = msg.GetFruidInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.IpmiWriteFrudata = {
    name = 'IpmiWriteFrudata',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x12,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<FruDeviceId:1/unit:8, OffsetLs:1/unit:8, OffsetM]=] .. [=[s:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Count:1/unit:8>>]=],
    req = msg.IpmiWriteFrudataReq,
    rsp = msg.IpmiWriteFrudataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.GetComponentInfo = {
    name = 'GetComponentInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[29]=],
    decode = [=[<<0x29:1/unit:8, BoardIndex:1/unit:8, InfoType:1/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ComponentInfo/string>>]=],
    req = msg.GetComponentInfoReq,
    rsp = msg.GetComponentInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.IpmiDftCustom = {
    name = 'IpmiDftCustom',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[21,04]=],
    decode = [=[<<0x21:1/unit:8, 0x04:1/unit:8, CustomizeFlag:1/un]=] .. [=[it:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.IpmiDftCustomReq,
    rsp = msg.IpmiDftCustomRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.IpmiGetDftCustom = {
    name = 'IpmiGetDftCustom',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[59,04]=],
    decode = [=[<<0x59:1/unit:8, 0x04:1/unit:8, Reserved:2/unit:8>]=] .. [=[>]=],
    encode = [=[<<CompletionCode:1/unit:8, Reserved:1/unit:8, Conf]=] .. [=[igParameter:1/unit:8>>]=],
    req = msg.IpmiGetDftCustomReq,
    rsp = msg.IpmiGetDftCustomRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

FrudataIpmiCmds.FruControlCapabilities = {
    name = 'FruControlCapabilities',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x1e,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruDeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgIdentifier:1/unit:]=] .. [=[8, FruControlMask:1/unit:8>>]=],
    req = msg.FruControlCapabilitiesReq,
    rsp = msg.FruControlCapabilitiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetFruInventory = {
    name = 'GetFruInventory',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x10,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<FruDeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, LSByte:1/unit:8, MSByte]=] .. [=[:1/unit:8, DeviceOfAccess:1/unit:8>>]=],
    req = msg.GetFruInventoryReq,
    rsp = msg.GetFruInventoryRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetFruidFromUid = {
    name = 'GetFruidFromUid',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6D]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6D:1/unit:8, Reserved:]=] .. [=[1/unit:8, UidLen:1/unit:8, Uid/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Count:1/unit:8, Fruid/string>>]=],
    req = msg.GetFruidFromUidReq,
    rsp = msg.GetFruidFromUidRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.ReadFruData = {
    name = 'ReadFruData',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x11,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<FruId:1/unit:8, Offset:2/unit:8, Length:1/unit:8]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Count:1/unit:8, Data/st]=] .. [=[ring>>]=],
    req = msg.ReadFruDataReq,
    rsp = msg.ReadFruDataRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetComponentPositionInfo = {
    name = 'GetComponentPositionInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[3F]=],
    decode = [=[<<0x3F:1/unit:8, Type:1/unit:8, PositionInfo/strin]=] .. [=[g>>]=],
    encode = [=[<<CompletionCode:1/unit:8, FruId:1/unit:8, UniqueI]=] .. [=[d:4/unit:8, SilkText/string>>]=],
    req = msg.GetComponentPositionInfoReq,
    rsp = msg.GetComponentPositionInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDevicePresence = {
    name = 'GetDevicePresence',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x02:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDevicePresenceReq,
    rsp = msg.GetDevicePresenceRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceHealth = {
    name = 'GetDeviceHealth',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,03]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x03:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceHealthReq,
    rsp = msg.GetDeviceHealthRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceBoardID = {
    name = 'GetDeviceBoardID',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,06]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x06:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceBoardIDReq,
    rsp = msg.GetDeviceBoardIDRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceLocation = {
    name = 'GetDeviceLocation',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,08]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x08:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceLocationReq,
    rsp = msg.GetDeviceLocationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceFunction = {
    name = 'GetDeviceFunction',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,09]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x09:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceFunctionReq,
    rsp = msg.GetDeviceFunctionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceName = {
    name = 'GetDeviceName',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,0A]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x0A:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceNameReq,
    rsp = msg.GetDeviceNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceGroupID = {
    name = 'GetDeviceGroupID',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,0B]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x0B:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceGroupIDReq,
    rsp = msg.GetDeviceGroupIDRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceFruid = {
    name = 'GetDeviceFruid',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,10]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x10:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceFruidReq,
    rsp = msg.GetDeviceFruidRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetDeviceUniqueId = {
    name = 'GetDeviceUniqueId',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,23]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x23:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDeviceUniqueIdReq,
    rsp = msg.GetDeviceUniqueIdRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

FrudataIpmiCmds.GetGeneralDeviceManufacture = {
    name = 'GetGeneralDeviceManufacture',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,*,*,63]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceNumber:1/unit:8, 0x63:1/unit:8, ]=] .. [=[ReadOffset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, DeviceManufactureName/string>]=] .. [=[>]=],
    req = msg.GetGeneralDeviceManufactureReq,
    rsp = msg.GetGeneralDeviceManufactureRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

return FrudataIpmiCmds
