--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReadElabelData = {}

---@class FrudataIpmiCmds.ReadElabelDataReq
---@field FruId integer
---@field Area integer
---@field Field integer
---@field Offset integer
---@field Len integer
local TReadElabelDataReq = {}
TReadElabelDataReq.__index = TReadElabelDataReq
TReadElabelDataReq.group = {}

local function TReadElabelDataReq_from_obj(obj)
    return setmetatable(obj, TReadElabelDataReq)
end

function TReadElabelDataReq.new(FruId, Area, Field, Offset, Len)
    return TReadElabelDataReq_from_obj({FruId = FruId, Area = Area, Field = Field, Offset = Offset, Len = Len})
end
---@param obj FrudataIpmiCmds.ReadElabelDataReq
function TReadElabelDataReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Area = obj.Area
    self.Field = obj.Field
    self.Offset = obj.Offset
    self.Len = obj.Len
end

function TReadElabelDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadElabelDataReq.group)
end

TReadElabelDataReq.from_obj = TReadElabelDataReq_from_obj

TReadElabelDataReq.proto_property = {'FruId', 'Area', 'Field', 'Offset', 'Len'}

TReadElabelDataReq.default = {0, 0, 0, 0, 0}

TReadElabelDataReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Area', is_array = false, struct = nil},
    {name = 'Field', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Len', is_array = false, struct = nil}
}

function TReadElabelDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Area', self.Area, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Field', self.Field, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Len', self.Len, 'uint8', false, errs, need_convert)

    TReadElabelDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadElabelDataReq.proto_property, errs, need_convert)
    return self
end

function TReadElabelDataReq:unpack(_)
    return self.FruId, self.Area, self.Field, self.Offset, self.Len
end

ReadElabelData.ReadElabelDataReq = TReadElabelDataReq

---@class FrudataIpmiCmds.ReadElabelDataRsp
---@field CompletionCode integer
---@field EndFlag integer
---@field RespDatas string
local TReadElabelDataRsp = {}
TReadElabelDataRsp.__index = TReadElabelDataRsp
TReadElabelDataRsp.group = {}

local function TReadElabelDataRsp_from_obj(obj)
    return setmetatable(obj, TReadElabelDataRsp)
end

function TReadElabelDataRsp.new(CompletionCode, EndFlag, RespDatas)
    return TReadElabelDataRsp_from_obj({CompletionCode = CompletionCode, EndFlag = EndFlag, RespDatas = RespDatas})
end
---@param obj FrudataIpmiCmds.ReadElabelDataRsp
function TReadElabelDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndFlag = obj.EndFlag
    self.RespDatas = obj.RespDatas
end

function TReadElabelDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadElabelDataRsp.group)
end

TReadElabelDataRsp.from_obj = TReadElabelDataRsp_from_obj

TReadElabelDataRsp.proto_property = {'CompletionCode', 'EndFlag', 'RespDatas'}

TReadElabelDataRsp.default = {0, 0, ''}

TReadElabelDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndFlag', is_array = false, struct = nil},
    {name = 'RespDatas', is_array = false, struct = nil}
}

function TReadElabelDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RespDatas', self.RespDatas, 'string', false, errs, need_convert)

    TReadElabelDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadElabelDataRsp.proto_property, errs, need_convert)
    return self
end

function TReadElabelDataRsp:unpack(_)
    return self.CompletionCode, self.EndFlag, self.RespDatas
end

ReadElabelData.ReadElabelDataRsp = TReadElabelDataRsp

return ReadElabelData
