--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local IpmiGetDftCustom = {}

---@class FrudataIpmiCmds.IpmiGetDftCustomReq
---@field Reserved integer
local TIpmiGetDftCustomReq = {}
TIpmiGetDftCustomReq.__index = TIpmiGetDftCustomReq
TIpmiGetDftCustomReq.group = {}

local function TIpmiGetDftCustomReq_from_obj(obj)
    return setmetatable(obj, TIpmiGetDftCustomReq)
end

function TIpmiGetDftCustomReq.new(Reserved)
    return TIpmiGetDftCustomReq_from_obj({Reserved = Reserved})
end
---@param obj FrudataIpmiCmds.IpmiGetDftCustomReq
function TIpmiGetDftCustomReq:init_from_obj(obj)
    self.Reserved = obj.Reserved
end

function TIpmiGetDftCustomReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiGetDftCustomReq.group)
end

TIpmiGetDftCustomReq.from_obj = TIpmiGetDftCustomReq_from_obj

TIpmiGetDftCustomReq.proto_property = {'Reserved'}

TIpmiGetDftCustomReq.default = {0}

TIpmiGetDftCustomReq.struct = {{name = 'Reserved', is_array = false, struct = nil}}

function TIpmiGetDftCustomReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint16', false, errs, need_convert)

    TIpmiGetDftCustomReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiGetDftCustomReq.proto_property, errs, need_convert)
    return self
end

function TIpmiGetDftCustomReq:unpack(_)
    return self.Reserved
end

IpmiGetDftCustom.IpmiGetDftCustomReq = TIpmiGetDftCustomReq

---@class FrudataIpmiCmds.IpmiGetDftCustomRsp
---@field CompletionCode integer
---@field Reserved integer
---@field ConfigParameter integer
local TIpmiGetDftCustomRsp = {}
TIpmiGetDftCustomRsp.__index = TIpmiGetDftCustomRsp
TIpmiGetDftCustomRsp.group = {}

local function TIpmiGetDftCustomRsp_from_obj(obj)
    return setmetatable(obj, TIpmiGetDftCustomRsp)
end

function TIpmiGetDftCustomRsp.new(CompletionCode, Reserved, ConfigParameter)
    return TIpmiGetDftCustomRsp_from_obj({
        CompletionCode = CompletionCode,
        Reserved = Reserved,
        ConfigParameter = ConfigParameter
    })
end
---@param obj FrudataIpmiCmds.IpmiGetDftCustomRsp
function TIpmiGetDftCustomRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Reserved = obj.Reserved
    self.ConfigParameter = obj.ConfigParameter
end

function TIpmiGetDftCustomRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiGetDftCustomRsp.group)
end

TIpmiGetDftCustomRsp.from_obj = TIpmiGetDftCustomRsp_from_obj

TIpmiGetDftCustomRsp.proto_property = {'CompletionCode', 'Reserved', 'ConfigParameter'}

TIpmiGetDftCustomRsp.default = {0, 0, 0}

TIpmiGetDftCustomRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ConfigParameter', is_array = false, struct = nil}
}

function TIpmiGetDftCustomRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigParameter', self.ConfigParameter, 'uint8', false, errs, need_convert)

    TIpmiGetDftCustomRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiGetDftCustomRsp.proto_property, errs, need_convert)
    return self
end

function TIpmiGetDftCustomRsp:unpack(_)
    return self.CompletionCode, self.Reserved, self.ConfigParameter
end

IpmiGetDftCustom.IpmiGetDftCustomRsp = TIpmiGetDftCustomRsp

return IpmiGetDftCustom
