--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local IpmiDftCustom = {}

---@class FrudataIpmiCmds.IpmiDftCustomReq
---@field CustomizeFlag integer
local TIpmiDftCustomReq = {}
TIpmiDftCustomReq.__index = TIpmiDftCustomReq
TIpmiDftCustomReq.group = {}

local function TIpmiDftCustomReq_from_obj(obj)
    return setmetatable(obj, TIpmiDftCustomReq)
end

function TIpmiDftCustomReq.new(CustomizeFlag)
    return TIpmiDftCustomReq_from_obj({CustomizeFlag = CustomizeFlag})
end
---@param obj FrudataIpmiCmds.IpmiDftCustomReq
function TIpmiDftCustomReq:init_from_obj(obj)
    self.CustomizeFlag = obj.CustomizeFlag
end

function TIpmiDftCustomReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiDftCustomReq.group)
end

TIpmiDftCustomReq.from_obj = TIpmiDftCustomReq_from_obj

TIpmiDftCustomReq.proto_property = {'CustomizeFlag'}

TIpmiDftCustomReq.default = {0}

TIpmiDftCustomReq.struct = {{name = 'CustomizeFlag', is_array = false, struct = nil}}

function TIpmiDftCustomReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CustomizeFlag', self.CustomizeFlag, 'uint8', false, errs, need_convert)

    TIpmiDftCustomReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiDftCustomReq.proto_property, errs, need_convert)
    return self
end

function TIpmiDftCustomReq:unpack(_)
    return self.CustomizeFlag
end

IpmiDftCustom.IpmiDftCustomReq = TIpmiDftCustomReq

---@class FrudataIpmiCmds.IpmiDftCustomRsp
---@field CompletionCode integer
local TIpmiDftCustomRsp = {}
TIpmiDftCustomRsp.__index = TIpmiDftCustomRsp
TIpmiDftCustomRsp.group = {}

local function TIpmiDftCustomRsp_from_obj(obj)
    return setmetatable(obj, TIpmiDftCustomRsp)
end

function TIpmiDftCustomRsp.new(CompletionCode)
    return TIpmiDftCustomRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj FrudataIpmiCmds.IpmiDftCustomRsp
function TIpmiDftCustomRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TIpmiDftCustomRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiDftCustomRsp.group)
end

TIpmiDftCustomRsp.from_obj = TIpmiDftCustomRsp_from_obj

TIpmiDftCustomRsp.proto_property = {'CompletionCode'}

TIpmiDftCustomRsp.default = {0}

TIpmiDftCustomRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TIpmiDftCustomRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TIpmiDftCustomRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiDftCustomRsp.proto_property, errs, need_convert)
    return self
end

function TIpmiDftCustomRsp:unpack(_)
    return self.CompletionCode
end

IpmiDftCustom.IpmiDftCustomRsp = TIpmiDftCustomRsp

return IpmiDftCustom
