--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFruidFromUid = {}

---@class FrudataIpmiCmds.GetFruidFromUidReq
---@field ManufactureId integer
---@field Reserved integer
---@field UidLen integer
---@field Uid string
local TGetFruidFromUidReq = {}
TGetFruidFromUidReq.__index = TGetFruidFromUidReq
TGetFruidFromUidReq.group = {}

local function TGetFruidFromUidReq_from_obj(obj)
    return setmetatable(obj, TGetFruidFromUidReq)
end

function TGetFruidFromUidReq.new(ManufactureId, Reserved, UidLen, Uid)
    return
        TGetFruidFromUidReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, UidLen = UidLen, Uid = Uid})
end
---@param obj FrudataIpmiCmds.GetFruidFromUidReq
function TGetFruidFromUidReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.UidLen = obj.UidLen
    self.Uid = obj.Uid
end

function TGetFruidFromUidReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruidFromUidReq.group)
end

TGetFruidFromUidReq.from_obj = TGetFruidFromUidReq_from_obj

TGetFruidFromUidReq.proto_property = {'ManufactureId', 'Reserved', 'UidLen', 'Uid'}

TGetFruidFromUidReq.default = {0, 0, 0, ''}

TGetFruidFromUidReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'UidLen', is_array = false, struct = nil}, {name = 'Uid', is_array = false, struct = nil}
}

function TGetFruidFromUidReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UidLen', self.UidLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Uid', self.Uid, 'string', false, errs, need_convert)

    TGetFruidFromUidReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruidFromUidReq.proto_property, errs, need_convert)
    return self
end

function TGetFruidFromUidReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.UidLen, self.Uid
end

GetFruidFromUid.GetFruidFromUidReq = TGetFruidFromUidReq

---@class FrudataIpmiCmds.GetFruidFromUidRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Count integer
---@field Fruid string
local TGetFruidFromUidRsp = {}
TGetFruidFromUidRsp.__index = TGetFruidFromUidRsp
TGetFruidFromUidRsp.group = {}

local function TGetFruidFromUidRsp_from_obj(obj)
    return setmetatable(obj, TGetFruidFromUidRsp)
end

function TGetFruidFromUidRsp.new(CompletionCode, ManufactureId, Count, Fruid)
    return TGetFruidFromUidRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Count = Count,
        Fruid = Fruid
    })
end
---@param obj FrudataIpmiCmds.GetFruidFromUidRsp
function TGetFruidFromUidRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Count = obj.Count
    self.Fruid = obj.Fruid
end

function TGetFruidFromUidRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruidFromUidRsp.group)
end

TGetFruidFromUidRsp.from_obj = TGetFruidFromUidRsp_from_obj

TGetFruidFromUidRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Count', 'Fruid'}

TGetFruidFromUidRsp.default = {0, 0, 0, ''}

TGetFruidFromUidRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Count', is_array = false, struct = nil}, {name = 'Fruid', is_array = false, struct = nil}
}

function TGetFruidFromUidRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Fruid', self.Fruid, 'string', false, errs, need_convert)

    TGetFruidFromUidRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruidFromUidRsp.proto_property, errs, need_convert)
    return self
end

function TGetFruidFromUidRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Count, self.Fruid
end

GetFruidFromUid.GetFruidFromUidRsp = TGetFruidFromUidRsp

return GetFruidFromUid
