--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFruInventory = {}

---@class FrudataIpmiCmds.GetFruInventoryReq
---@field FruDeviceId integer
local TGetFruInventoryReq = {}
TGetFruInventoryReq.__index = TGetFruInventoryReq
TGetFruInventoryReq.group = {}

local function TGetFruInventoryReq_from_obj(obj)
    return setmetatable(obj, TGetFruInventoryReq)
end

function TGetFruInventoryReq.new(FruDeviceId)
    return TGetFruInventoryReq_from_obj({FruDeviceId = FruDeviceId})
end
---@param obj FrudataIpmiCmds.GetFruInventoryReq
function TGetFruInventoryReq:init_from_obj(obj)
    self.FruDeviceId = obj.FruDeviceId
end

function TGetFruInventoryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruInventoryReq.group)
end

TGetFruInventoryReq.from_obj = TGetFruInventoryReq_from_obj

TGetFruInventoryReq.proto_property = {'FruDeviceId'}

TGetFruInventoryReq.default = {0}

TGetFruInventoryReq.struct = {{name = 'FruDeviceId', is_array = false, struct = nil}}

function TGetFruInventoryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruDeviceId', self.FruDeviceId, 'uint8', false, errs, need_convert)

    TGetFruInventoryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruInventoryReq.proto_property, errs, need_convert)
    return self
end

function TGetFruInventoryReq:unpack(_)
    return self.FruDeviceId
end

GetFruInventory.GetFruInventoryReq = TGetFruInventoryReq

---@class FrudataIpmiCmds.GetFruInventoryRsp
---@field CompletionCode integer
---@field LSByte integer
---@field MSByte integer
---@field DeviceOfAccess integer
local TGetFruInventoryRsp = {}
TGetFruInventoryRsp.__index = TGetFruInventoryRsp
TGetFruInventoryRsp.group = {}

local function TGetFruInventoryRsp_from_obj(obj)
    return setmetatable(obj, TGetFruInventoryRsp)
end

function TGetFruInventoryRsp.new(CompletionCode, LSByte, MSByte, DeviceOfAccess)
    return TGetFruInventoryRsp_from_obj({
        CompletionCode = CompletionCode,
        LSByte = LSByte,
        MSByte = MSByte,
        DeviceOfAccess = DeviceOfAccess
    })
end
---@param obj FrudataIpmiCmds.GetFruInventoryRsp
function TGetFruInventoryRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.LSByte = obj.LSByte
    self.MSByte = obj.MSByte
    self.DeviceOfAccess = obj.DeviceOfAccess
end

function TGetFruInventoryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruInventoryRsp.group)
end

TGetFruInventoryRsp.from_obj = TGetFruInventoryRsp_from_obj

TGetFruInventoryRsp.proto_property = {'CompletionCode', 'LSByte', 'MSByte', 'DeviceOfAccess'}

TGetFruInventoryRsp.default = {0, 0, 0, 0}

TGetFruInventoryRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'LSByte', is_array = false, struct = nil},
    {name = 'MSByte', is_array = false, struct = nil}, {name = 'DeviceOfAccess', is_array = false, struct = nil}
}

function TGetFruInventoryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LSByte', self.LSByte, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MSByte', self.MSByte, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceOfAccess', self.DeviceOfAccess, 'uint8', false, errs, need_convert)

    TGetFruInventoryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruInventoryRsp.proto_property, errs, need_convert)
    return self
end

function TGetFruInventoryRsp:unpack(_)
    return self.CompletionCode, self.LSByte, self.MSByte, self.DeviceOfAccess
end

GetFruInventory.GetFruInventoryRsp = TGetFruInventoryRsp

return GetFruInventory
