--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceHealth = {}

---@class FrudataIpmiCmds.GetDeviceHealthReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceHealthReq = {}
TGetDeviceHealthReq.__index = TGetDeviceHealthReq
TGetDeviceHealthReq.group = {}

local function TGetDeviceHealthReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceHealthReq)
end

function TGetDeviceHealthReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceHealthReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceHealthReq
function TGetDeviceHealthReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceHealthReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceHealthReq.group)
end

TGetDeviceHealthReq.from_obj = TGetDeviceHealthReq_from_obj

TGetDeviceHealthReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceHealthReq.default = {0, 0, 0, 0, 0}

TGetDeviceHealthReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceHealthReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceHealthReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceHealthReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceHealthReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceHealth.GetDeviceHealthReq = TGetDeviceHealthReq

---@class FrudataIpmiCmds.GetDeviceHealthRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceHealthRsp = {}
TGetDeviceHealthRsp.__index = TGetDeviceHealthRsp
TGetDeviceHealthRsp.group = {}

local function TGetDeviceHealthRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceHealthRsp)
end

function TGetDeviceHealthRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceHealthRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceHealthRsp
function TGetDeviceHealthRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceHealthRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceHealthRsp.group)
end

TGetDeviceHealthRsp.from_obj = TGetDeviceHealthRsp_from_obj

TGetDeviceHealthRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceHealthRsp.default = {0, 0, 0, ''}

TGetDeviceHealthRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceHealthRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceHealthRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceHealthRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceHealthRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceHealth.GetDeviceHealthRsp = TGetDeviceHealthRsp

return GetDeviceHealth
