--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceGroupID = {}

---@class FrudataIpmiCmds.GetDeviceGroupIDReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceGroupIDReq = {}
TGetDeviceGroupIDReq.__index = TGetDeviceGroupIDReq
TGetDeviceGroupIDReq.group = {}

local function TGetDeviceGroupIDReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceGroupIDReq)
end

function TGetDeviceGroupIDReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceGroupIDReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceGroupIDReq
function TGetDeviceGroupIDReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceGroupIDReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceGroupIDReq.group)
end

TGetDeviceGroupIDReq.from_obj = TGetDeviceGroupIDReq_from_obj

TGetDeviceGroupIDReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceGroupIDReq.default = {0, 0, 0, 0, 0}

TGetDeviceGroupIDReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceGroupIDReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceGroupIDReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceGroupIDReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceGroupIDReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceGroupID.GetDeviceGroupIDReq = TGetDeviceGroupIDReq

---@class FrudataIpmiCmds.GetDeviceGroupIDRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceGroupIDRsp = {}
TGetDeviceGroupIDRsp.__index = TGetDeviceGroupIDRsp
TGetDeviceGroupIDRsp.group = {}

local function TGetDeviceGroupIDRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceGroupIDRsp)
end

function TGetDeviceGroupIDRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceGroupIDRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceGroupIDRsp
function TGetDeviceGroupIDRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceGroupIDRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceGroupIDRsp.group)
end

TGetDeviceGroupIDRsp.from_obj = TGetDeviceGroupIDRsp_from_obj

TGetDeviceGroupIDRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceGroupIDRsp.default = {0, 0, 0, ''}

TGetDeviceGroupIDRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceGroupIDRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceGroupIDRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceGroupIDRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceGroupIDRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceGroupID.GetDeviceGroupIDRsp = TGetDeviceGroupIDRsp

return GetDeviceGroupID
