--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetComponentPositionInfo = {}

---@class FrudataIpmiCmds.GetComponentPositionInfoReq
---@field Type integer
---@field PositionInfo string
local TGetComponentPositionInfoReq = {}
TGetComponentPositionInfoReq.__index = TGetComponentPositionInfoReq
TGetComponentPositionInfoReq.group = {}

local function TGetComponentPositionInfoReq_from_obj(obj)
    return setmetatable(obj, TGetComponentPositionInfoReq)
end

function TGetComponentPositionInfoReq.new(Type, PositionInfo)
    return TGetComponentPositionInfoReq_from_obj({Type = Type, PositionInfo = PositionInfo})
end
---@param obj FrudataIpmiCmds.GetComponentPositionInfoReq
function TGetComponentPositionInfoReq:init_from_obj(obj)
    self.Type = obj.Type
    self.PositionInfo = obj.PositionInfo
end

function TGetComponentPositionInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentPositionInfoReq.group)
end

TGetComponentPositionInfoReq.from_obj = TGetComponentPositionInfoReq_from_obj

TGetComponentPositionInfoReq.proto_property = {'Type', 'PositionInfo'}

TGetComponentPositionInfoReq.default = {0, ''}

TGetComponentPositionInfoReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'PositionInfo', is_array = false, struct = nil}
}

function TGetComponentPositionInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PositionInfo', self.PositionInfo, 'string', false, errs, need_convert)

    TGetComponentPositionInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentPositionInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetComponentPositionInfoReq:unpack(_)
    return self.Type, self.PositionInfo
end

GetComponentPositionInfo.GetComponentPositionInfoReq = TGetComponentPositionInfoReq

---@class FrudataIpmiCmds.GetComponentPositionInfoRsp
---@field CompletionCode integer
---@field FruId integer
---@field UniqueId integer
---@field SilkText string
local TGetComponentPositionInfoRsp = {}
TGetComponentPositionInfoRsp.__index = TGetComponentPositionInfoRsp
TGetComponentPositionInfoRsp.group = {}

local function TGetComponentPositionInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetComponentPositionInfoRsp)
end

function TGetComponentPositionInfoRsp.new(CompletionCode, FruId, UniqueId, SilkText)
    return TGetComponentPositionInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        FruId = FruId,
        UniqueId = UniqueId,
        SilkText = SilkText
    })
end
---@param obj FrudataIpmiCmds.GetComponentPositionInfoRsp
function TGetComponentPositionInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.FruId = obj.FruId
    self.UniqueId = obj.UniqueId
    self.SilkText = obj.SilkText
end

function TGetComponentPositionInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentPositionInfoRsp.group)
end

TGetComponentPositionInfoRsp.from_obj = TGetComponentPositionInfoRsp_from_obj

TGetComponentPositionInfoRsp.proto_property = {'CompletionCode', 'FruId', 'UniqueId', 'SilkText'}

TGetComponentPositionInfoRsp.default = {0, 0, 0, ''}

TGetComponentPositionInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'UniqueId', is_array = false, struct = nil}, {name = 'SilkText', is_array = false, struct = nil}
}

function TGetComponentPositionInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UniqueId', self.UniqueId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', false, errs, need_convert)

    TGetComponentPositionInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentPositionInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetComponentPositionInfoRsp:unpack(_)
    return self.CompletionCode, self.FruId, self.UniqueId, self.SilkText
end

GetComponentPositionInfo.GetComponentPositionInfoRsp = TGetComponentPositionInfoRsp

return GetComponentPositionInfo
