--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetAddressInfo = {}

---@class FrudataIpmiCmds.GetAddressInfoReq
---@field FruId string
local TGetAddressInfoReq = {}
TGetAddressInfoReq.__index = TGetAddressInfoReq
TGetAddressInfoReq.group = {}

local function TGetAddressInfoReq_from_obj(obj)
    return setmetatable(obj, TGetAddressInfoReq)
end

function TGetAddressInfoReq.new(FruId)
    return TGetAddressInfoReq_from_obj({FruId = FruId})
end
---@param obj FrudataIpmiCmds.GetAddressInfoReq
function TGetAddressInfoReq:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TGetAddressInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAddressInfoReq.group)
end

TGetAddressInfoReq.from_obj = TGetAddressInfoReq_from_obj

TGetAddressInfoReq.proto_property = {'FruId'}

TGetAddressInfoReq.default = {''}

TGetAddressInfoReq.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TGetAddressInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'string', false, errs, need_convert)

    TGetAddressInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAddressInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetAddressInfoReq:unpack(_)
    return self.FruId
end

GetAddressInfo.GetAddressInfoReq = TGetAddressInfoReq

---@class FrudataIpmiCmds.GetAddressInfoRsp
---@field CompletionCode integer
---@field Identifier integer
---@field HardwareAddr integer
---@field IpmbAddr integer
---@field Reserved integer
---@field Id integer
---@field SiteNumber integer
---@field SiteType integer
local TGetAddressInfoRsp = {}
TGetAddressInfoRsp.__index = TGetAddressInfoRsp
TGetAddressInfoRsp.group = {}

local function TGetAddressInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetAddressInfoRsp)
end

function TGetAddressInfoRsp.new(CompletionCode, Identifier, HardwareAddr, IpmbAddr, Reserved, Id, SiteNumber, SiteType)
    return TGetAddressInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        Identifier = Identifier,
        HardwareAddr = HardwareAddr,
        IpmbAddr = IpmbAddr,
        Reserved = Reserved,
        Id = Id,
        SiteNumber = SiteNumber,
        SiteType = SiteType
    })
end
---@param obj FrudataIpmiCmds.GetAddressInfoRsp
function TGetAddressInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Identifier = obj.Identifier
    self.HardwareAddr = obj.HardwareAddr
    self.IpmbAddr = obj.IpmbAddr
    self.Reserved = obj.Reserved
    self.Id = obj.Id
    self.SiteNumber = obj.SiteNumber
    self.SiteType = obj.SiteType
end

function TGetAddressInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAddressInfoRsp.group)
end

TGetAddressInfoRsp.from_obj = TGetAddressInfoRsp_from_obj

TGetAddressInfoRsp.proto_property = {
    'CompletionCode', 'Identifier', 'HardwareAddr', 'IpmbAddr', 'Reserved', 'Id', 'SiteNumber', 'SiteType'
}

TGetAddressInfoRsp.default = {0, 0, 0, 0, 0, 0, 0, 0}

TGetAddressInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Identifier', is_array = false, struct = nil},
    {name = 'HardwareAddr', is_array = false, struct = nil}, {name = 'IpmbAddr', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil},
    {name = 'SiteNumber', is_array = false, struct = nil}, {name = 'SiteType', is_array = false, struct = nil}
}

function TGetAddressInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Identifier', self.Identifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'HardwareAddr', self.HardwareAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IpmbAddr', self.IpmbAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SiteNumber', self.SiteNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SiteType', self.SiteType, 'uint8', false, errs, need_convert)

    TGetAddressInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAddressInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetAddressInfoRsp:unpack(_)
    return self.CompletionCode, self.Identifier, self.HardwareAddr, self.IpmbAddr, self.Reserved, self.Id,
        self.SiteNumber, self.SiteType
end

GetAddressInfo.GetAddressInfoRsp = TGetAddressInfoRsp

return GetAddressInfo
