--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local FruControlCapabilities = {}

---@class FrudataIpmiCmds.FruControlCapabilitiesReq
---@field FruDeviceId integer
local TFruControlCapabilitiesReq = {}
TFruControlCapabilitiesReq.__index = TFruControlCapabilitiesReq
TFruControlCapabilitiesReq.group = {}

local function TFruControlCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TFruControlCapabilitiesReq)
end

function TFruControlCapabilitiesReq.new(FruDeviceId)
    return TFruControlCapabilitiesReq_from_obj({FruDeviceId = FruDeviceId})
end
---@param obj FrudataIpmiCmds.FruControlCapabilitiesReq
function TFruControlCapabilitiesReq:init_from_obj(obj)
    self.FruDeviceId = obj.FruDeviceId
end

function TFruControlCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruControlCapabilitiesReq.group)
end

TFruControlCapabilitiesReq.from_obj = TFruControlCapabilitiesReq_from_obj

TFruControlCapabilitiesReq.proto_property = {'FruDeviceId'}

TFruControlCapabilitiesReq.default = {0}

TFruControlCapabilitiesReq.struct = {{name = 'FruDeviceId', is_array = false, struct = nil}}

function TFruControlCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruDeviceId', self.FruDeviceId, 'uint8', false, errs, need_convert)

    TFruControlCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruControlCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TFruControlCapabilitiesReq:unpack(_)
    return self.FruDeviceId
end

FruControlCapabilities.FruControlCapabilitiesReq = TFruControlCapabilitiesReq

---@class FrudataIpmiCmds.FruControlCapabilitiesRsp
---@field CompletionCode integer
---@field PicmgIdentifier integer
---@field FruControlMask integer
local TFruControlCapabilitiesRsp = {}
TFruControlCapabilitiesRsp.__index = TFruControlCapabilitiesRsp
TFruControlCapabilitiesRsp.group = {}

local function TFruControlCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TFruControlCapabilitiesRsp)
end

function TFruControlCapabilitiesRsp.new(CompletionCode, PicmgIdentifier, FruControlMask)
    return TFruControlCapabilitiesRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgIdentifier = PicmgIdentifier,
        FruControlMask = FruControlMask
    })
end
---@param obj FrudataIpmiCmds.FruControlCapabilitiesRsp
function TFruControlCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.FruControlMask = obj.FruControlMask
end

function TFruControlCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruControlCapabilitiesRsp.group)
end

TFruControlCapabilitiesRsp.from_obj = TFruControlCapabilitiesRsp_from_obj

TFruControlCapabilitiesRsp.proto_property = {'CompletionCode', 'PicmgIdentifier', 'FruControlMask'}

TFruControlCapabilitiesRsp.default = {0, 0, 0}

TFruControlCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'PicmgIdentifier', is_array = false, struct = nil},
    {name = 'FruControlMask', is_array = false, struct = nil}
}

function TFruControlCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruControlMask', self.FruControlMask, 'uint8', false, errs, need_convert)

    TFruControlCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruControlCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TFruControlCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.PicmgIdentifier, self.FruControlMask
end

FruControlCapabilities.FruControlCapabilitiesRsp = TFruControlCapabilitiesRsp

return FruControlCapabilities
