-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

---@class PersistentInformationTable: Table
---@field FruId FieldBase
---@field PersistentName FieldBase
---@field PersistentValue FieldBase

---@class ComponentMappingTable: Table
---@field PreviousSN FieldBase
---@field ComponentName FieldBase

---@class PositionFruIdMappingTable: Table
---@field Position FieldBase
---@field Id FieldBase

---@class FrudataDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field PersistentInformation PersistentInformationTable
---@field ComponentMapping ComponentMappingTable
---@field PositionFruIdMapping PositionFruIdMappingTable
local FrudataDBDatabase = {}
FrudataDBDatabase.__index = FrudataDBDatabase

function FrudataDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.PersistentInformation = db:Table('t_persistence_info', {
        FruId = Col.IntegerField():cid(1):primary_key():max_length(8),
        PersistentName = Col.TextField():cid(2):null(),
        PersistentValue = Col.TextField():cid(3):null()
    }, 'protect_temporary'):create_if_not_exist(datas and datas['t_persistence_info'])
    obj.ComponentMapping = db:Table('t_component_mapping', {
        PreviousSN = Col.TextField():cid(1):persistence_key('protect_power_off'):null(),
        ComponentName = Col.TextField():cid(2):primary_key():persistence_key('protect_power_off')
    }):create_if_not_exist(datas and datas['t_component_mapping'])
    obj.PositionFruIdMapping = db:Table('t_position_fru_id_mapping', {
        Position = Col.TextField():cid(1):persistence_key('protect_power_off'):null(),
        Id = Col.IntegerField():cid(2):primary_key():persistence_key('protect_power_off'):max_length(8)
    }):create_if_not_exist(datas and datas['t_position_fru_id_mapping'])

    obj.tables = db.tables
    return setmetatable(obj, FrudataDBDatabase)
end

function FrudataDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function FrudataDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function FrudataDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function FrudataDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function FrudataDBDatabase:exec(...)
    return self.db:exec(...)
end

return FrudataDBDatabase.new
