-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftVersion = {}

---@class MDftVersion.NeedUintNum
---@field NeedUintNum integer
local TNeedUintNum = {}
TNeedUintNum.__index = TNeedUintNum
TNeedUintNum.group = {}

local function TNeedUintNum_from_obj(obj)
    return setmetatable(obj, TNeedUintNum)
end

function TNeedUintNum.new(NeedUintNum)
    return TNeedUintNum_from_obj({NeedUintNum = NeedUintNum})
end
---@param obj MDftVersion.NeedUintNum
function TNeedUintNum:init_from_obj(obj)
    self.NeedUintNum = obj.NeedUintNum
end

function TNeedUintNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNeedUintNum.group)
end

TNeedUintNum.from_obj = TNeedUintNum_from_obj

TNeedUintNum.proto_property = {'NeedUintNum'}

TNeedUintNum.default = {0}

TNeedUintNum.struct = {{name = 'NeedUintNum', is_array = false, struct = nil}}

function TNeedUintNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NeedUintNum', self.NeedUintNum, 'uint8', false, errs, need_convert)

    TNeedUintNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNeedUintNum.proto_property, errs, need_convert)
    return self
end

function TNeedUintNum:unpack(_)
    return self.NeedUintNum
end

MDftVersion.NeedUintNum = TNeedUintNum

---@class MDftVersion.UnitNum
---@field UnitNum integer
local TUnitNum = {}
TUnitNum.__index = TUnitNum
TUnitNum.group = {}

local function TUnitNum_from_obj(obj)
    return setmetatable(obj, TUnitNum)
end

function TUnitNum.new(UnitNum)
    return TUnitNum_from_obj({UnitNum = UnitNum})
end
---@param obj MDftVersion.UnitNum
function TUnitNum:init_from_obj(obj)
    self.UnitNum = obj.UnitNum
end

function TUnitNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnitNum.group)
end

TUnitNum.from_obj = TUnitNum_from_obj

TUnitNum.proto_property = {'UnitNum'}

TUnitNum.default = {0}

TUnitNum.struct = {{name = 'UnitNum', is_array = false, struct = nil}}

function TUnitNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnitNum', self.UnitNum, 'uint32', false, errs, need_convert)

    TUnitNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnitNum.proto_property, errs, need_convert)
    return self
end

function TUnitNum:unpack(_)
    return self.UnitNum
end

MDftVersion.UnitNum = TUnitNum

---@class MDftVersion.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MDftVersion.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MDftVersion.Version = TVersion

---@class MDftVersion.VersionType
---@field VersionType integer
local TVersionType = {}
TVersionType.__index = TVersionType
TVersionType.group = {}

local function TVersionType_from_obj(obj)
    return setmetatable(obj, TVersionType)
end

function TVersionType.new(VersionType)
    return TVersionType_from_obj({VersionType = VersionType})
end
---@param obj MDftVersion.VersionType
function TVersionType:init_from_obj(obj)
    self.VersionType = obj.VersionType
end

function TVersionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersionType.group)
end

TVersionType.from_obj = TVersionType_from_obj

TVersionType.proto_property = {'VersionType'}

TVersionType.default = {0}

TVersionType.struct = {{name = 'VersionType', is_array = false, struct = nil}}

function TVersionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VersionType', self.VersionType, 'uint8', false, errs, need_convert)

    TVersionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersionType.proto_property, errs, need_convert)
    return self
end

function TVersionType:unpack(_)
    return self.VersionType
end

MDftVersion.VersionType = TVersionType

---@class MDftVersion.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj MDftVersion.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

MDftVersion.FruId = TFruId

return MDftVersion
