-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MComponentMapping = {}

---@class MComponentMapping.ComponentName
---@field ComponentName string
local TComponentName = {}
TComponentName.__index = TComponentName
TComponentName.group = {}

local function TComponentName_from_obj(obj)
    return setmetatable(obj, TComponentName)
end

function TComponentName.new(ComponentName)
    return TComponentName_from_obj({ComponentName = ComponentName})
end
---@param obj MComponentMapping.ComponentName
function TComponentName:init_from_obj(obj)
    self.ComponentName = obj.ComponentName
end

function TComponentName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentName.group)
end

TComponentName.from_obj = TComponentName_from_obj

TComponentName.proto_property = {'ComponentName'}

TComponentName.default = {''}

TComponentName.struct = {{name = 'ComponentName', is_array = false, struct = nil}}

function TComponentName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ComponentName', self.ComponentName, 'string', false, errs, need_convert)

    TComponentName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentName.proto_property, errs, need_convert)
    return self
end

function TComponentName:unpack(_)
    return self.ComponentName
end

MComponentMapping.ComponentName = TComponentName

---@class MComponentMapping.PreviousSN
---@field PreviousSN string
local TPreviousSN = {}
TPreviousSN.__index = TPreviousSN
TPreviousSN.group = {}

local function TPreviousSN_from_obj(obj)
    return setmetatable(obj, TPreviousSN)
end

function TPreviousSN.new(PreviousSN)
    return TPreviousSN_from_obj({PreviousSN = PreviousSN})
end
---@param obj MComponentMapping.PreviousSN
function TPreviousSN:init_from_obj(obj)
    self.PreviousSN = obj.PreviousSN
end

function TPreviousSN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreviousSN.group)
end

TPreviousSN.from_obj = TPreviousSN_from_obj

TPreviousSN.proto_property = {'PreviousSN'}

TPreviousSN.default = {''}

TPreviousSN.struct = {{name = 'PreviousSN', is_array = false, struct = nil}}

function TPreviousSN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreviousSN', self.PreviousSN, 'string', false, errs, need_convert)

    TPreviousSN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreviousSN.proto_property, errs, need_convert)
    return self
end

function TPreviousSN:unpack(_)
    return self.PreviousSN
end

MComponentMapping.PreviousSN = TPreviousSN

return MComponentMapping
