-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local context = require 'mc.context'
local skynet = require 'skynet'
local log = require 'mc.logging'
local m_enums = require 'types.enums'

local utils_core = require 'utils.core'

local M = {}

M.power_ctrl_state_enums = {
    INITED = 0,
    PROCESSING = 1,
    INTERRUPTED = 2,
}

function M.wait_chassis_power_off(power_cycle_ins, power_off_timeout)
    log:notice("wait power off in power cycle process")
    skynet.sleep(10)
    return true
end

return M