-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local PayloadEnums = {}

PayloadEnums.PowerCtrlType = {
    ['On'] = 'On',
    ['ForceOff'] = 'ForceOff',
    ['GracefulShutdown'] = 'GracefulShutdown',
    ['GracefulRestart'] = 'GracefulRestart',
    ['ForceRestart'] = 'ForceRestart',
    ['Nmi'] = 'Nmi',
    ['ForceOn'] = 'ForceOn',
    ['PushPowerButton'] = 'PushPowerButton',
    ['PowerCycle'] = 'PowerCycle',
    ['ForcePowerCycle'] = 'ForcePowerCycle',
    ['ACCycle'] = 'ACCycle',
    ['Suspend'] = 'Suspend',
    ['Pause'] = 'Pause',
    ['Resume'] = 'Resume',
}

PayloadEnums.RestartCause = {
    ['Unknown'] = 'Unknown',
    ['ChassisControlCommand'] = 'ChassisControlCommand',
    ['ResetViaPushButton'] = 'ResetViaPushButton',
    ['PowerUpViaPushButton'] = 'PowerUpViaPushButton',
    ['WatchdogExpiration'] = 'WatchdogExpiration',
    ['Oem'] = 'Oem',
    ['ACRestoreAlwaysPowerUp'] = 'ACRestoreAlwaysPowerUp',
    ['ACRestoreKeepPreviousState'] = 'ACRestoreKeepPreviousState',
    ['ResetViaPEF'] = 'ResetViaPEF',
    ['PowerCycleViaPEF'] = 'PowerCycleViaPEF',
    ['SoftReset'] = 'SoftReset',
    ['PowerupViaRTC'] = 'PowerupViaRTC',
    ['ACSPCollect'] = 'ACSPCollect'
}

-- 与ipmi模块定义的通道标识含义一致
PayloadEnums.ChannelId= {
    ['CT_IPMB'] = 0x00,
    ['CT_LAN'] = 0x01,
    ['CT_IPMB_SM'] = 0x06,
    ['CT_IPMB_ETH'] = 0x08,
    ['CT_EDMA'] = 0x09,
    ['CT_INNER_CMD'] = 0x0D,
    ['CT_SYS'] = 0x0F,
}

PayloadEnums.RestartCauseId = {
    ['Unknown'] = 1,
    ['ChassisControlCommand'] = 2,
    ['ResetViaPushButton'] = 3,
    ['PowerUpViaPushButton'] = 4,
    ['WatchdogExpiration'] = 5,
    ['Oem'] = 6,
    ['ACRestoreAlwaysPowerUp'] = 7,
    ['ACRestoreKeepPreviousState'] = 8,
    ['ResetViaPEF'] = 9,
    ['PowerCycleViaPEF'] = 10,
    ['SoftReset'] = 11,
    ['PowerupViaRTC'] = 12,
    ['ACSPCollect'] = 13
}

PayloadEnums.RestartInitiateId = {
    ['InitiatedByPowerUp'] = 0,
    ['InitiatedByHardReset'] = 1,
    ['InitiatedByWarmReset'] = 2,
    ['UserRequestedPXEBoot'] = 3,
    ['AutomaticBootToDiagnostic'] = 4,
    ['OSInitiatedHardReset'] = 5,
    ['OSInitiatedWarmReset'] = 6,
    ['SystemRestart'] = 7,
    ['None'] = 255,
}

PayloadEnums.PowerRestorePolicy = {
    ['AlwaysPowerOff'] = 'AlwaysPowerOff',
    ['AlwaysPowerOn'] = 'AlwaysPowerOn',
    ['LastState'] = 'LastState',
}

PayloadEnums.DelayPowerOnPolicy = {
    ['DefaultDelay'] = 'DefaultDelay',
    ['HalfDelay'] = 'HalfDelay',
    ['FixedDelay'] = 'FixedDelay',
    ['RandomDelay'] = 'RandomDelay',
}

PayloadEnums.PowerStatus = {
    ['ON'] = 'ON',
    ['OFF'] = 'OFF',
    ['ONING'] = 'ONING',
    ['OFFING'] = 'OFFING',
}

PayloadEnums.CtrlEventTypes = {
    ['CtrlPowerOn'] = 'CtrlPowerOn',
    ['CtrlPowerOff'] = 'CtrlPowerOff',
    ['CtrlFinished'] = 'CtrlFinished',
}

PayloadEnums.HotswapEventTypes = {
    ['FruPinMated'] = 'FruPinMated',
    ['FruInsertionCriteriaMet'] = 'FruInsertionCriteriaMet',
    ['FruExtractionCriteriaMet'] = 'FruExtractionCriteriaMet',
    ['FruActivated'] = 'FruActivated',
    ['FruActivatedCompleted'] = 'FruActivatedCompleted',
    ['FruDeactivated'] = 'FruDeactivated',
    ['FruDeactivatedCompleted'] = 'FruDeactivatedCompleted',
    ['FruPowerFailure'] = 'FruPowerFailure',
    ['FruSetPowerLevel0'] = 'FruSetPowerLevel0',
    ['FruUnexpectedEdactivation'] = 'FruUnexpectedEdactivation',
    ['FruUnnomalStateRecovery'] = 'FruUnnomalStateRecovery',
    ['FruCommunicationLost'] = 'FruCommunicationLost',
}

PayloadEnums.PowerOnDelayMode = {
    ['DefaultDelay'] = 'DefaultDelay',
    ['HalfDelay'] = 'HalfDelay',
    ['FixedDelay'] = 'FixedDelay',
    ['RandomDelay'] = 'RandomDelay',
}

PayloadEnums.PowerCycleType = {
    [1] = 'PowerCycle',
    [2] = 'ForcePowerCycle',
    ['PowerCycle'] = 1,
    ['ForcePowerCycle'] = 2
}

PayloadEnums.RetValue = {
    ['OK'] = 0,
    ['ERR'] = -1,
}

PayloadEnums.FruId = {
    ['OS'] = 0,
    ['GlobalDomain'] = 4,
}

PayloadEnums.HotswapStateToNum = {
    ['M0'] = 0,
    ['M1'] = 1,
    ['M2'] = 2,
    ['M3'] = 3,
    ['M4'] = 4,
    ['M5'] = 5,
    ['M6'] = 6,
    ['M7'] = 7
}

PayloadEnums.PGSignalState = {
    ['ON'] = 'ON',
    ['OFF'] = 'OFF',
    ['ONING'] = 'OFF',
    ['OFFING'] = 'ON',
}

return PayloadEnums