-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 系统锁定状态

local log = require 'mc.logging'
local class = require 'mc.class'
local utils = require 'types.utils'
local multihost = require 'multi_host'

local c_sys_lockdown = class()

function c_sys_lockdown:ctor(db, object, id)
    self.db = db
    self.obj = object
    self.system_id = id
    self.multihost_ins = multihost.get_instance()
    log:notice("set c_sys_lockdown object successfully, uptime: %s.", utils.uptime())

    object:get_mdb_object('bmc.kepler.Systems.SystemLockDown').property_changed:on(function(name, value, _)
        if  name == 'SystemLockDownStatus' then
            self:set_system_lockdown_status_record_log(value)
        end
    end)
end

function c_sys_lockdown:set_system_lockdown_status_record_log(val)
    -- 入参仅为Locked或Unlocked
    if val == 'Locked' then
        utils.record_prop_change_operation_log(self.multihost_ins:is_multihost_type() and self.system_id or nil,
            'Enable system lockdown successfully')
    elseif val == 'Unlocked' then
        utils.record_prop_change_operation_log(self.multihost_ins:is_multihost_type() and self.system_id or nil,
            'Disable system lockdown successfully')
    end
end

function c_sys_lockdown:get_system_lockdown_support()
    return self.obj.SystemLockDownSupport
end

function c_sys_lockdown:set_system_lockdown_status(val)
    self.obj.SystemLockDownStatus = val
end

function c_sys_lockdown:get_system_lockdown_status()
    return self.obj.SystemLockDownStatus
end

return c_sys_lockdown