-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Multihost

local log = require 'mc.logging'
local class = require 'mc.class'
local singleton = require 'mc.singleton'

local c_multihost = class()

function c_multihost:ctor()

end

function c_multihost:register_object(object)
    self.obj = object
    log:notice("register multihost object successfully")
end

function c_multihost:is_multihost_type()
    if not self.obj then
        return false
    end
    return self.obj.HostType == 'Multihost'
end

function c_multihost:get_host_count()
    if not self.obj then
        return 1
    end
    return self.obj.HostType == 'Multihost' and self.obj.HostCount or 1
end

return singleton(c_multihost)