-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local log = require 'mc.logging'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local utils_core = require 'utils.core'

local fructrl_dump = {}

function fructrl_dump.log_dump_cb(ctx, path)
    if not path then
        log:error('path is incorrect')
        return false
    end

    -- 安全检查
    if file_sec.check_shell_special_character_s(path) ~= 0 then
        log:error('Command injection error in fructrl_dump!!!')
        return false
    end
    os.execute('mkdir -p ' .. path)
    local file_name = path .. '/fructrl_info.txt'
    local fp = file_sec.open_s(file_name, "w+")
    if not fp then
        log:error('open fructrl_info failed')
        return false
    end
    return utils.safe_close_file(fp, function()
        utils_core.chmod_s(file_name, utils.S_IRUSR | utils.S_IWUSR | utils.S_IRGRP)

        local buf = {}
        -- 没有需要记录的信息，打印模块正常。
        buf[#buf + 1] = string.format('Fructrl is normal.\r\n')
        fp:write(table.concat(buf))

        return true
    end)
end

return fructrl_dump
