-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FruCtrlCapabilities = {}

---@class FruCtrlCapabilities.MultihostSupported
---@field MultihostSupported boolean
local TMultihostSupported = {}
TMultihostSupported.__index = TMultihostSupported
TMultihostSupported.group = {}

local function TMultihostSupported_from_obj(obj)
    return setmetatable(obj, TMultihostSupported)
end

function TMultihostSupported.new(MultihostSupported)
    return TMultihostSupported_from_obj({MultihostSupported = MultihostSupported})
end
---@param obj FruCtrlCapabilities.MultihostSupported
function TMultihostSupported:init_from_obj(obj)
    self.MultihostSupported = obj.MultihostSupported
end

function TMultihostSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostSupported.group)
end

TMultihostSupported.from_obj = TMultihostSupported_from_obj

TMultihostSupported.proto_property = {'MultihostSupported'}

TMultihostSupported.default = {false}

TMultihostSupported.struct = {{name = 'MultihostSupported', is_array = false, struct = nil}}

function TMultihostSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultihostSupported', self.MultihostSupported, 'bool', true, errs, need_convert)

    TMultihostSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostSupported.proto_property, errs, need_convert)
    return self
end

function TMultihostSupported:unpack(_)
    return self.MultihostSupported
end

FruCtrlCapabilities.MultihostSupported = TMultihostSupported

---@class FruCtrlCapabilities.GlobalDomainSupported
---@field GlobalDomainSupported boolean
local TGlobalDomainSupported = {}
TGlobalDomainSupported.__index = TGlobalDomainSupported
TGlobalDomainSupported.group = {}

local function TGlobalDomainSupported_from_obj(obj)
    return setmetatable(obj, TGlobalDomainSupported)
end

function TGlobalDomainSupported.new(GlobalDomainSupported)
    return TGlobalDomainSupported_from_obj({GlobalDomainSupported = GlobalDomainSupported})
end
---@param obj FruCtrlCapabilities.GlobalDomainSupported
function TGlobalDomainSupported:init_from_obj(obj)
    self.GlobalDomainSupported = obj.GlobalDomainSupported
end

function TGlobalDomainSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalDomainSupported.group)
end

TGlobalDomainSupported.from_obj = TGlobalDomainSupported_from_obj

TGlobalDomainSupported.proto_property = {'GlobalDomainSupported'}

TGlobalDomainSupported.default = {false}

TGlobalDomainSupported.struct = {{name = 'GlobalDomainSupported', is_array = false, struct = nil}}

function TGlobalDomainSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalDomainSupported', self.GlobalDomainSupported, 'bool', true, errs, need_convert)

    TGlobalDomainSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalDomainSupported.proto_property, errs, need_convert)
    return self
end

function TGlobalDomainSupported:unpack(_)
    return self.GlobalDomainSupported
end

FruCtrlCapabilities.GlobalDomainSupported = TGlobalDomainSupported

FruCtrlCapabilities.interface = mdb.register_interface('bmc.kepler.ProductInfo.FruCtrlCapabilities', {
    GlobalDomainSupported = {'b', nil, true, nil, false},
    MultihostSupported = {'b', nil, true, nil, false}
}, {}, {})

return FruCtrlCapabilities
