-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Env = {}

---@class Env.EnvActiveModes: Enum
local EEnvActiveModes = create_enum_type('EnvActiveModes')
EEnvActiveModes.default = EEnvActiveModes.new(2147483647)
EEnvActiveModes.struct = nil
EEnvActiveModes.None = EEnvActiveModes.new(0)
EEnvActiveModes.ResetBMC = EEnvActiveModes.new(1)
EEnvActiveModes.ResetBMCAndSecureCore = EEnvActiveModes.new(2)
EEnvActiveModes.ResetBMCAndSecureCoreOnPowerDown = EEnvActiveModes.new(3)
EEnvActiveModes.ACCycle = EEnvActiveModes.new(4)

Env.EnvActiveModes = EEnvActiveModes

---@class Env.ActiveMode
---@field ActiveMode Env.EnvActiveModes
local TActiveMode = {}
TActiveMode.__index = TActiveMode
TActiveMode.group = {}

local function TActiveMode_from_obj(obj)
    obj.ActiveMode = obj.ActiveMode and Env.EnvActiveModes.new(obj.ActiveMode)
    return setmetatable(obj, TActiveMode)
end

function TActiveMode.new(ActiveMode)
    return TActiveMode_from_obj({ActiveMode = ActiveMode or [=[None]=]})
end
---@param obj Env.ActiveMode
function TActiveMode:init_from_obj(obj)
    self.ActiveMode = obj.ActiveMode or Env.EnvActiveModes.None
end

function TActiveMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveMode.group)
end

TActiveMode.from_obj = TActiveMode_from_obj

TActiveMode.proto_property = {'ActiveMode'}

TActiveMode.default = {Env.EnvActiveModes.default}

TActiveMode.struct = {{name = 'ActiveMode', is_array = false, struct = Env.EnvActiveModes.struct}}

function TActiveMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveMode', self.ActiveMode, 'Env.EnvActiveModes', false, errs, need_convert)

    TActiveMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveMode.proto_property, errs, need_convert)
    return self
end

function TActiveMode:unpack(raw)
    local ActiveMode = utils.unpack_enum(raw, self.ActiveMode)
    return ActiveMode
end

Env.ActiveMode = TActiveMode

---@class Env.IsChanged
---@field IsChanged boolean
local TIsChanged = {}
TIsChanged.__index = TIsChanged
TIsChanged.group = {}

local function TIsChanged_from_obj(obj)
    return setmetatable(obj, TIsChanged)
end

function TIsChanged.new(IsChanged)
    return TIsChanged_from_obj({IsChanged = IsChanged or false})
end
---@param obj Env.IsChanged
function TIsChanged:init_from_obj(obj)
    self.IsChanged = obj.IsChanged or false
end

function TIsChanged:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsChanged.group)
end

TIsChanged.from_obj = TIsChanged_from_obj

TIsChanged.proto_property = {'IsChanged'}

TIsChanged.default = {false}

TIsChanged.struct = {{name = 'IsChanged', is_array = false, struct = nil}}

function TIsChanged:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsChanged', self.IsChanged, 'bool', false, errs, need_convert)

    TIsChanged:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsChanged.proto_property, errs, need_convert)
    return self
end

function TIsChanged:unpack(_)
    return self.IsChanged
end

Env.IsChanged = TIsChanged

---@class Env.LoadCompleted
---@field LoadCompleted boolean
local TLoadCompleted = {}
TLoadCompleted.__index = TLoadCompleted
TLoadCompleted.group = {}

local function TLoadCompleted_from_obj(obj)
    return setmetatable(obj, TLoadCompleted)
end

function TLoadCompleted.new(LoadCompleted)
    return TLoadCompleted_from_obj({LoadCompleted = LoadCompleted or false})
end
---@param obj Env.LoadCompleted
function TLoadCompleted:init_from_obj(obj)
    self.LoadCompleted = obj.LoadCompleted or false
end

function TLoadCompleted:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoadCompleted.group)
end

TLoadCompleted.from_obj = TLoadCompleted_from_obj

TLoadCompleted.proto_property = {'LoadCompleted'}

TLoadCompleted.default = {false}

TLoadCompleted.struct = {{name = 'LoadCompleted', is_array = false, struct = nil}}

function TLoadCompleted:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LoadCompleted', self.LoadCompleted, 'bool', false, errs, need_convert)

    TLoadCompleted:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoadCompleted.proto_property, errs, need_convert)
    return self
end

function TLoadCompleted:unpack(_)
    return self.LoadCompleted
end

Env.LoadCompleted = TLoadCompleted

Env.interface = mdb.register_interface('bmc.kepler.Managers.SOC.Env', {
    LoadCompleted = {'b', nil, false, false, false},
    IsChanged = {'b', nil, false, false, false},
    ActiveMode = {'i', nil, false, utils.unpack_enum(true, EEnvActiveModes.None), false}
}, {}, {})

return Env
